load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin
 print ("=========================================")
 print ("Starting:  chk_grid.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 dd= systemfunc("date -u +%y%m%d")

 IPATH  = "./"
 ifile1 = IPATH + "/topography.ieeei4"           ; kmt in bin format
 ifile2 = IPATH + "/region_mask.ieeei4"          ; region_mask in bin format
 ofile  = "./region_mask-kmt.nc"

;NOTE lat and lon are hardcoded to regular POP Grid
 nlon = 320
 nlat = 384 
 dims = (/nlat,nlon/)

 vtype = "float"
; ==============================================
; == Read in kmt from topography file
; == Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------
; ==============================================
; NOTE:  fortran is column major .... NCL [C] is row major
; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
; ==============================================

 if (.not. isbigendian()) then
        setfileoption ("bin", "ReadByteOrder", "BigEndian")
        setfileoption ("bin", "WriteByteOrder","BigEndian")
 end if
 
 ikmt = fbindirread(ifile1,0,dims,vtype)
 ireg = fbindirread(ifile2,0,dims,vtype)

; ==============================================
; Mask kmt and region_masks to compare records.
; ==============================================

 ikmt = where(ikmt.eq.0,0,1)
 ireg = where(ireg.eq.0,0,1)
 dff = ireg - ikmt;
 if((any(dff.ne.0)) )

 	nlon  = 320
 	nlat  = 384 

	lat = ispan(1,384,1)
	lon = ispan(1,320,1)

	print("Found some errors.  Printing output file " + ofile)
  	system("/bin/rm -f " + ofile)
 	fout = addfile(ofile,"c")
 	fileAtt             = True
 	fileAtt@title       = ireg + " - " + ikmt
 	fileAtt@conventions = "CCSM"
 	fileAtt@create_date = systemfunc("date")

 	dimNames = (/"lat","lon"/)
 	dimSizes = (/nlat,nlon/)
 	dimUnlim = (/False,False/)

 	otype = (/"lat","lon"/)

 	filedimdef(fout,dimNames,dimSizes,dimUnlim)
 	filevardef(fout,"kmt",vtype,otype)
 	filevardef(fout,"reg",vtype,otype)
	
 	fout->dff = dff

	; plot results

 	; wks = gsn_open_wks("X11","diffMap")
 	wks = gsn_open_wks("ps","diffMap")
 	gsn_define_colormap(wks,"BlueDarkRed18")

 	res = True
 	res@gsnMaximize = True
 	res@gsnPaperOrientation = "portrait"
 	res@cnFillOn = True
	res@mpOutlineOn            = False         ; Turn on map outlines
	res@mpFillOn               = False         ; Turn on map fill
 	; res@lbLabelBarOn = False
 	res@gsnCenterString = "("+ ireg + ") - (" + ikmt + ")"
 	res@gsnLeftString =  " "
 	res@gsnRightString = " "
 	plot = gsn_csm_contour_map_ce(wks,dff,res)
 else
	print("Region mask and KMT match exactly")
 end if

       ; plot results

        ; wks = gsn_open_wks("X11","diffMap2")
        wks = gsn_open_wks("ps","diffMap2")
        gsn_define_colormap(wks,"BlueDarkRed18")

        res = True
        res@gsnMaximize = True
        res@gsnPaperOrientation = "portrait"
        res@cnFillOn = True
        res@mpOutlineOn            = False         ; Turn on map outlines
        res@mpFillOn               = False         ; Turn on map fill
        res@lbLabelBarOn = False
        res@gsnCenterString = "("+ ikmt + ") - (" + ireg + ")"
        res@gsnLeftString =  " "
        res@gsnRightString = " "
        ; plot = gsn_csm_contour_map_ce(wks,dff,res)

end
