load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; remember big/little endian 
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  change_region.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 dd= systemfunc("date -u +%y%m%d")

 ifile    = "region.ieeei4.orig"	     ; kmt in netcdf format
 ofile    = "region_55ma_arctic_ms_"+dd+".nc"
 ofilebin = "region_55ma_arctic_ms_"+dd+".ieeei4"
 vtype = "integer"
 npts = 0

; NOTE lat and lon are hardcoded to regular POP Grid
 nlon = 100
 nlat = 116 + npts
 dims = (/nlat,nlon/)

; ==============================================
; == Read in kmt from topography file
; ==============================================
; NOTE:  fortran is column major .... NCL [C] is row major
; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
; ==============================================

 setfileoption("bin","ReadByteOrder","BigEndian")
 reg0 = fbindirread(ifile,0,dims,vtype)

; ==============================================
; make mods 
; ==============================================
reg = reg0  ; maintain array shape
do nt = 0,nlat-1
do nl = 0,nlon-1
 if(reg0(nt,nl).eq.1)then
   reg(nt,nl) = -1
 end if
end do
end do
 

; ==============================================
;  write out new reg in direct access binary 
; ==============================================

  setfileoption("bin","WriteByteOrder","BigEndian")
  system("/bin/rm -f " + ofilebin)
  fbindirwrite(ofilebin,reg)

; ==============================================
;  write out new reg in netcdf to check it
; ==============================================

 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")

 fileAtt             = True
 fileAtt@title       = "make arctic ocean in 55ma/PETM marginal sea, -1"
 fileAtt@conventions = "none"
 fileAtt@create_date = systemfunc("date")
 fileAtt@src_code = "change_region.ncl"
 fileAtt@author = "CShields"
 fileAtt@input = ifile
 fileattdef(fout,fileAtt)

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"reg",vtype,otype)

 fout->reg = reg 

end
