; =========== author nan rosenbloom ====================
; takes kmt and ocean T/S history data and create a
; (lat,lon,depth) ocean binary initial file.
;=======================================================

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  mk_TSic.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ocnTSfile = "b30.petm_wp13x.pop.h.1800-01.nc"
 fkmti  = "checktoporeg.nc"		; kmt on old tgrid 
 fTSi   =  ocnTSfile		; TS history file 
 casename  = "b30.petm_wp13x"		

 dd= systemfunc("date -u +%y%m%d")
 ofile    = "TSic_"+casename+"_"+dd+".nc"
 ofilebin = "TSic_"+casename+"_"+dd+".ieeer8"
 vtype = "double"

km = 25
;old grid dimensions:
nlat = 116
nlng = 100

 dims3n = (/km,nlat,nlng/)
 dims2n = (/nlat,nlng/)

; ==============================================
; == Read in kmt from topography files
; ==============================================
 ifile = addfile(fkmti,"r")
 ikmt = ifile->kmt                
 delete(ifile)

; ==============================================
; == Read in T and S from history file
; ==============================================
 ifile = addfile(fTSi,"r")
 TEMPi = ifile->TEMP(0,:,:,:)
 SALTi = ifile->SALT(0,:,:,:)
 if(isatt(SALTi,"scale_factor")) then
   SALTi = SALTi*SALTi@scale_factor  
   delete(SALTi@scale_factor)
 end if
 delete(ifile)

;==========================
; t/s mods here
;==========================
TEMPn = flt2dble(TEMPi)
SALTn = flt2dble(SALTi)
printVarSummary(TEMPn)

;================================
; write binary T/S for ocean init
;===============================

   system("/bin/rm -f " + ofilebin)

; Note:  NCL switches dimension order:  (/lev,lat,lon/)  => binary(lon,lat,lev) which is how the ocn files are stored.
   fbindirwrite(ofilebin,TEMPn)
   fbindirwrite(ofilebin,SALTn)



; ==============================================
;  write out new  T and S in netcdf to check it
; ==============================================

 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")

 fileAtt             = True
 fileAtt@title       = "TEMP and SALT Initial Condition file from "+casename
 fileAtt@conventions = "none"
 fileAtt@create_date = systemfunc("date")
 fileAtt@src_code = "mk_TSic.ncl"
 fileAtt@author = "nanr (Nan Rosenbloom)"
 fileAtt@input = ocnTSfile 
 fileattdef(fout,fileAtt)

 dimNames = (/"depth","lat","lon"/)
 dimSizes = (/km,nlat,nlng/)
 dimUnlim = (/False,False,False/)

 otype = (/"depth","lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"TEMP","double",otype)
 filevardef(fout,"SALT","double",otype)

 fout->TEMP = (/TEMPn/) 
 fout->SALT = (/SALTn/) 

end

