; =========== author nan rosenbloom ====================
; takes kmt and ocean T/S history data and create a
; (lat,lon,depth) ocean binary initial file.
;=======================================================

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  mk_TSic.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 PROC  = "/fis/cgd/ccr/nanr/wais/CCSM_noLand/preProc"

 ocnTSfile = "ocnt.pccsm.08b.03990101.nc"
 fkmti  = PROC  + "/topography_20010702.nc"		; kmt on old tgrid 
 fTSi   = PROC + "/" + ocnTSfile		; TS history file 
 casename  = "pccsm.08b"		

 dd= systemfunc("date -u +%y%m%d")
 ofile    = "TSic_LIG_cntl_"+dd+".nc"
 ofilebin = "TSic_LIG_cntl_"+dd+".ieeer8"
 vtype = "double"

km = 40
;old grid dimensions:
nlat = 384
nlng = 320

 dims3n = (/km,nlat,nlng/)
 dims2n = (/nlat,nlng/)

; ==============================================
; == Read in kmt from topography files
; ==============================================
 ifile = addfile(fkmti,"r")
 ikmt = ifile->kmt                
 delete(ifile)

; ==============================================
; == Read in T and S from old history file
; ==============================================
 ifile = addfile(fTSi,"r")
 TEMPi = ifile->TEMP(0,:,:,:)
 SALTi = ifile->SALT(0,:,:,:)
 if(isatt(SALTi,"scale_factor")) then
   SALTi = SALTi*SALTi@scale_factor  
   delete(SALTi@scale_factor)
 end if
 delete(ifile)

; ==========================================================
; == Replace new T and S with T and S from old history file
; ==========================================================
  TEMPn = new(dims3n,vtype)
  SALTn = new(dims3n,vtype)
  okmt =  new(dims2n,"integer")

  TEMPn=TEMPi(:,:,:)
  SALTn=SALTi(:,:,:)
  okmt=ikmt(:,:)

  zTEMPn = dim_avg(TEMPn) 
  zSALTn = dim_avg(SALTn) 
 
;fill out arrays with reasonable values:
   zTEMPn = where (ismissing(zTEMPn),0.0d0,zTEMPn)
   zSALTn = where (ismissing(zSALTn),34.7d0,zSALTn)

;replace land values with graceful values (just in case):
   TEMPn = where (ismissing(TEMPn),0.0d0,TEMPn)
   SALTn = where (ismissing(SALTn),34.7d0,SALTn)

   system("/bin/rm -f " + ofilebin)

; Note:  NCL switches dimension order:  (/lev,lat,lon/)  => binary(lon,lat,lev) which is how the ocn files are stored.
   fbindirwrite(ofilebin,TEMPn)
   fbindirwrite(ofilebin,SALTn)



; ==============================================
;  write out new  T and S in netcdf to check it
; ==============================================

 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")

 fileAtt             = True
 fileAtt@title       = "TEMP and SALT Initial Condition file from "+casename
 fileAtt@conventions = "none"
 fileAtt@create_date = systemfunc("date")
 fileAtt@src_code = "mk_TSic.ncl"
 fileAtt@author = "nanr (Nan Rosenbloom)"
 fileAtt@input = ocnTSfile 
 fileattdef(fout,fileAtt)

 dimNames = (/"depth","lat","lon"/)
 dimSizes = (/km,nlat,nlng/)
 dimUnlim = (/False,False,False/)

 otype = (/"depth","lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"TEMP","double",otype)
 filevardef(fout,"SALT","double",otype)

 fout->TEMP = (/TEMPn/) 
 fout->SALT = (/SALTn/) 

end

