;=========================================================; 
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

fili = "100ma_topo_2x2_070403.nc"
filo = "100ma_topo_0.5x0.5_070403.nc"

fin  = addfile(fili,"r")
system("/bin/rm -f " + filo)
fout = addfile(filo,"c")

ilat = fin->lat
ilon = fin->lon
topf = fin->topo

 nlat = 360
 nlon = 720
 lon = new((/nlon/),float)
 lat = new((/nlat/),float)

 ; create lon
 sl = 0.25
 do i = 0,nlon-1
        lon(i) = sl 
	sl = sl + 0.5
  end do

  ; create lat
  sl = -89.75
  do i = 0,nlat-1
        lat(i) = sl
        sl = sl + 0.5
  end do

  lat!0="lat"
  lon!0="lon"

print("topf = " + topf(0:4,0))

  top = linint2_Wrap (ilon,ilat,topf, True, lon,lat, 0)
print("top = " + top(0:4,0))
  top@long_name = "100ma topo/bathy 0.5x0.5 resolution"

printVarSummary(top)

  fileAtt               = True
  fileAtt@creation_date = systemfunc("date")
  fileAtt@input         = "100ma_topo_2x2_070403.nc"
  fileAtt@src           = "create0.5x0.5.ncl"
  fileAtt@contents      = "100ma topo + bathymetry 0.5x0.5"
  fileattdef(fout, fileAtt)

  dimNames = (/"lat","lon"/)
  dimSizes = (/nlat,nlon/)
  dimUnlim = (/False,False/)
  filedimdef(fout,dimNames,dimSizes,dimUnlim)
  filevardef(fout,"topo","float",(/"lat","lon"/))    
  filevardef(fout,"lat",typeof(lat),"lat")
  filevardef(fout,"lon",typeof(lon),"lon")
  fout->topo = (/top/)
  fout->lat = (/lat/)
  fout->lon = (/lon/)

  delete(filo)
  delete(fin)
end
    


