load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  chk_grid.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ikmt  = "kmt.miocene.nc"		; kmt on tgrid 
 ireg  = "reg_mask_miocene.nc"		; kmt on tgrid 
 dd= systemfunc("date -u +%y%m%d")

 vtype = "float"

; ==============================================
; == Read in kmt from topography file
; ==============================================
 ifile1 = addfile(ikmt,"r")
 ifile2 = addfile(ireg,"r")
 kmt = ifile1->kmt                
 reg = ifile2->reg                
 delete(ifile1)
 delete(ifile2)

 kmt = where(kmt.eq.0,0,1)
 reg = where(reg.eq.0,0,1)
 dff = reg - kmt;
 if((any(dff.ne.0)) )
	print("Found some errors.  Check output map")

 	nlon  = 320
 	nlat  = 384 

	lat = ispan(1,384,1)
	lon = ispan(1,320,1)

	ofile = "./region_mask-kmt.nc"
  	system("/bin/rm -f " + ofile)
 	fout = addfile(ofile,"c")
 	fileAtt             = True
 	fileAtt@title       = ireg + " - " + ikmt
 	fileAtt@conventions = "CCSM"
 	fileAtt@create_date = systemfunc("date")

 	dimNames = (/"lat","lon"/)
 	dimSizes = (/nlat,nlon/)
 	dimUnlim = (/False,False/)

 	otype = (/"lat","lon"/)

 	filedimdef(fout,dimNames,dimSizes,dimUnlim)
 	filevardef(fout,"kmt",vtype,otype)
 	filevardef(fout,"reg",vtype,otype)
	
 	fout->dff = dff


 else
	print("Region mask and KMT match exactly")
 end if

       ; plot results

        ; wks = gsn_open_wks("X11","diffMap")
        wks = gsn_open_wks("ps","diffMap")
        gsn_define_colormap(wks,"BlueDarkRed18")

        res = True
        res@gsnMaximize = True
        res@gsnPaperOrientation = "portrait"
        res@cnFillOn = True
        res@mpOutlineOn            = False         ; Turn on map outlines
        res@mpFillOn               = False         ; Turn on map fill
        res@lbLabelBarOn = False
        res@gsnCenterString = "("+ ikmt + ") - (" + ireg + ")"
        res@gsnLeftString =  " "
        res@gsnRightString = " "
        plot = gsn_csm_contour_map_ce(wks,dff,res)

end
