load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  change_kmt_8.2ka.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 dd= systemfunc("date -u +%y%m%d")

 IPATH = "/fs/cgd/csm/inputdata/ocn/pop/gx1v3/grid/"
 
 ifile    = IPATH + "/topography_20010702.ieeei4"	     ; kmt in netcdf format
 ofile    = "topography_8.2ka_"+dd+".nc"
 ofilebin = "topography_8.2ka_"+dd+".ieeei4"
 vtype = "integer"
 npts = 0

; NOTE lat and lon are hardcoded to regular POP Grid
 nlon = 320
 nlat = 384 + npts
 dims = (/nlat,nlon/)

; ==============================================
; == Read in kmt from topography file
; ==============================================
; NOTE:  fortran is column major .... NCL [C] is row major
; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
; ==============================================
 
 kmt = fbindirread(ifile,0,dims,vtype)

; ==============================================
; define Hudson Bay
; ==============================================

 mini = 326
 maxi = 347
 minj = 262
 maxj = 285

; ==============================================
; substitute Hudson Bay block with 0s (land)
; ==============================================
   kmt(mini:maxi,minj:maxj) = 0

; ==============================================
;  write out new kmt in direct access binary 
; ==============================================

  system("/bin/rm -f " + ofilebin)
  fbindirwrite(ofilebin,kmt)

; ==============================================
;  write out new kmt in netcdf to check it
; ==============================================

 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")

 fileAtt             = True
 fileAtt@title       = "Hudson Bay removed as ocn point for 8.5Ka ice sheet"
 fileAtt@conventions = "none"
 fileAtt@create_date = systemfunc("date")
 fileAtt@src_code = "change_kmt_8.2ka.ncl"
 fileAtt@author = "Nan Rosenbloom"
 fileAtt@input = ifile
 fileattdef(fout,fileAtt)

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"kmt",vtype,otype)

 fout->kmt = kmt

end
