load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file pop.da
; Write back out in plot.pop.da binary 
; Runs on linux (little endian) but reads/write big endian for
; ibm. if you want to change the endian type, see comments for
; different types 
;------------------------------------------------------
; linux = little
; ibm,sgi = big
;------------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  binda_r8_grid.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ipath = "/fis/cgd/cseg/csm/inputdata/ocn/pop/gx1v3/grid/"
 ifile = ipath + "horiz_grid_20010402.ieeer8"
 filop = "test.plot.da"

 npts = 0
 nptsp = 1
 vtype = "double"

 nlon  = 320
 nlat  = 384 + npts
 nlatp  = 384 + nptsp

 ; NOTE:  fortran is column major .... NCL [C] is row major
 ; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
 ;dims = (/nlon,nlat/)
 ;dimsp = (/nlon,nlatp/)
 dims = (/nlat,nlon/)
 dimsp = (/nlatp,nlon/)

 setfileoption("bin","ReadByteOrder","BigEndian")
 setfileoption("bin","WriteByteOrder","BigEndian")

 ulat = fbindirread(ifile,0,dims,vtype)
 ulng = fbindirread(ifile,1,dims,vtype)
 htn  = fbindirread(ifile,2,dims,vtype)
 hte  = fbindirread(ifile,3,dims,vtype)
 hus  = fbindirread(ifile,4,dims,vtype)
 huw  = fbindirread(ifile,5,dims,vtype)
 utan = fbindirread(ifile,6,dims,vtype)

; ==============================================
;  write out plot.da in direct access binary 
; ==============================================
ulatp = new((/nlatp,nlon/),double)
ulngp = new((/nlatp,nlon/),double)
ulatp(1:nlatp-1,:) = ulat
ulatp(0,:) = ulat(0,:)
ulngp(1:nlatp-1,:) = ulng
ulngp(0,:) = ulng(0,:)

fbindirwrite(filop,ulatp)
fbindirwrite(filop,ulngp)

end
