load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; -----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; Runs on linux, converts ibm big endian binary to linux
; little endian
;------------------------------------------------------
; linux = little
; ibm,sgi = big
; ----------------------------------------------------


begin
 print ("=========================================")
 print ("Starting:  binda2nc_r8.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ifile = "test.grid.plot.da"
 filo = "test.plotda.test.nc"

 npts = 1
 vtype = "double"

 nlon  = 320
 nlat  = 384 + npts


 ; NOTE:  fortran is column major .... NCL [C] is row major
 ; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
 dims = (/nlat,nlon/)

 setfileoption("bin","ReadByteOrder","BigEndian")
 ulat = fbindirread(ifile,0,dims,vtype)
 ulng = fbindirread(ifile,1,dims,vtype)


; ==============================================
;  write out grid in netcdf
; ==============================================
 
 system("/bin/rm -f " + filo)
 fout = addfile(filo,"c")
 fileAtt	     = True
 fileAtt@title	     = "Plotting version Horiz Grid"
 fileAtt@conventions = "CCSM"
 fileAtt@create_date = systemfunc("date")

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"ulat",vtype,otype)
 filevardef(fout,"ulng",vtype,otype)


 fout->ulat	= ulat
 fout->ulng	= ulng


end
