load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; -----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; Runs on linux, converts ibm big endian binary to linux
; little endian
;------------------------------------------------------
; linux = little
; ibm,sgi = big
; ----------------------------------------------------


begin
 print ("=========================================")
 print ("Starting:  binda2nc_r8.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ipath = "/fis/cgd/cseg/csm/inputdata/ocn/pop/gx1v3/grid/"
 ifile = ipath + "horiz_grid_20010402.ieeer8"
 filo = "test.nc"

 npts = 0
 vtype = "double"

 nlon  = 320
 nlat  = 384 + npts


 ; NOTE:  fortran is column major .... NCL [C] is row major
 ; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
 dims = (/nlat,nlon/)

 setfileoption("bin","ReadByteOrder","BigEndian")
 ulat = fbindirread(ifile,0,dims,vtype)
 ulng = fbindirread(ifile,1,dims,vtype)
 htn  = fbindirread(ifile,2,dims,vtype)
 hte  = fbindirread(ifile,3,dims,vtype)
 hus  = fbindirread(ifile,4,dims,vtype)
 huw  = fbindirread(ifile,5,dims,vtype)
 utan = fbindirread(ifile,6,dims,vtype)


; ==============================================
;  write out grid in netcdf
; ==============================================
 
 system("/bin/rm -f " + filo)
 fout = addfile(filo,"c")
 fileAtt	     = True
 fileAtt@title	     = "Horiz Grid"
 fileAtt@conventions = "CCSM"
 fileAtt@create_date = systemfunc("date")

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"ulat",vtype,otype)
 filevardef(fout,"ulng",vtype,otype)
 filevardef(fout,"htn",vtype,otype)
 filevardef(fout,"hte",vtype,otype)
 filevardef(fout,"hus",vtype,otype)
 filevardef(fout,"huw",vtype,otype)
 filevardef(fout,"utan",vtype,otype)


 fout->ulat	= ulat
 fout->ulng	= ulng
 fout->htn	= htn
 fout->hte	= hte
 fout->hus	= hus
 fout->huw      = huw	
 fout->utan	= utan


end
