load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  binda2nc.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ; ifile = "horiz_grid_20010402.ieeer8"
 ; ofile = "horiz_grid_20010402.nc"
 ; npts = 0
 ; vtype = "double"

 ; ifile = "horiz_grid_wais_070820.ieeer8"
 ; ofile = "horiz_grid_wais_070820.nc"
 ; npts = 10
 ; vtype = "double"

 ifile = "/fs/cgd/csm/inputdata/ocn/pop/gx1v3/forcing/chl_mm_SeaWiFs97-01_20030328.ieeer8"
 ofile = ""chl_mm_SeaWiFs97-01_2003032.nc
 npts = 0
 vtype = "double"

 nlon  = 320
 nlat  = 384 + npts

 ; NOTE:  fortran is column major .... NCL [C] is row major
 ; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
 dims = (/nlat,nlon/)

 setfileoption("bin","ReadByteOrder","LittleEndian")
 ulat = fbindirread(ifile,0,dims,vtype)
 ulng = fbindirread(ifile,1,dims,vtype)
 htn  = fbindirread(ifile,2,dims,vtype)
 hte  = fbindirread(ifile,3,dims,vtype)
 hus  = fbindirread(ifile,4,dims,vtype)
 huw  = fbindirread(ifile,5,dims,vtype)
 utan = fbindirread(ifile,6,dims,vtype)
 
 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")
 fileAtt	     = True
 fileAtt@title	     = "Horiz Grid"
 fileAtt@conventions = "CCSM"
 fileAtt@create_date = systemfunc("date")

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"ulat",vtype,otype)
 filevardef(fout,"ulng",vtype,otype)
 filevardef(fout,"htn",vtype,otype)
 filevardef(fout,"hte",vtype,otype)
 filevardef(fout,"hus",vtype,otype)
 filevardef(fout,"huw",vtype,otype)
 filevardef(fout,"utan",vtype,otype)

 filevarattdef(fout,"ulat",ulat)

 fout->ulat	= ulat
 fout->ulng	= ulng
 fout->htn	= htn
 fout->hte	= hte
 fout->hus	= hus
 fout->huw      = huw	
 fout->utan	= utan

end
