load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  binda2nc.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")

 ipath = "/fis/cgd/cseg/csm/inputdata/ocn/pop/gx1v3/grid/"
 ireg  = ipath + "region_mask_20010709.ieeei4"
 ; itopo = ipath + "topography_20010702.ieeei4"
 ; ofile = "topography_20010702.nc"

 itopo = "topography_wais.ieeei4"
 ofile = "topography_wais_remake.nc"
 npts = 0
 vtype = "integer"

 nlon  = 320
 nlat  = 384 + npts

 ; NOTE:  fortran is column major .... NCL [C] is row major
 ; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
 dims = (/nlat,nlon/)

 setfileoption("bin","ReadByteOrder","LittleEndian")
 kmt = fbindirread(itopo,0,dims,vtype)
 reg = fbindirread(ireg, 0,dims,vtype)
 
 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")
 fileAtt	     = True
 fileAtt@title	     = "Topography (kmt)"
 fileAtt@conventions = "CCSM"
 fileAtt@create_date = systemfunc("date")

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"kmt",vtype,otype)
 filevardef(fout,"reg",vtype,otype)

 fout->kmt = kmt
 fout->reg = reg

end
