load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

; ----------------------------------------------------
; Read binary direct access file and rewrite to netcdf
; ----------------------------------------------------

begin
 print ("=========================================")
 print ("Starting:  binda2nc.ncl")
 print ("Start Time: "+systemfunc("date") )
 print ("=========================================")


 ifile = "/fs/cgd/csm/inputdata/ocn/pop/gx1v3/forcing/chl_mm_SeaWiFs97-01_20030328.ieeer8"
 ofile = ""chl_mm_SeaWiFs97-01_2003032.nc
 npts = 0
 vtype = "double"

 nlon  = 320
 nlat  = 384 + npts

 ; NOTE:  fortran is column major .... NCL [C] is row major
 ; fortran(nlon,nlat)  <===> NCL(nlat,nlon)
 dims = (/nlat,nlon/)

 in = fbindirread(ifile,0,dims,vtype)
 
 system("/bin/rm -f " + ofile)
 fout = addfile(ofile,"c")
 fileAtt	     = True
 fileAtt@title	     = "Horiz Grid"
 fileAtt@conventions = "CCSM"
 fileAtt@create_date = systemfunc("date")

 dimNames = (/"lat","lon"/)
 dimSizes = (/nlat,nlon/)
 dimUnlim = (/False,False/)

 otype = (/"lat","lon"/)

 filedimdef(fout,dimNames,dimSizes,dimUnlim)
 filevardef(fout,"ulat",vtype,otype)
 filevardef(fout,"ulng",vtype,otype)
 filevardef(fout,"htn",vtype,otype)
 filevardef(fout,"hte",vtype,otype)
 filevardef(fout,"hus",vtype,otype)
 filevardef(fout,"huw",vtype,otype)
 filevardef(fout,"utan",vtype,otype)

 filevarattdef(fout,"ulat",ulat)

 fout->ulat	= ulat
 fout->ulng	= ulng
 fout->htn	= htn
 fout->hte	= hte
 fout->hus	= hus
 fout->huw      = huw	
 fout->utan	= utan

end
