#! /bin/csh -f

set echo 
set verbose

#---------------------------------------------------------------------------
# Make the input_template directory and input_template files for ocn and ice
#---------------------------------------------------------------------------

# ----------------------------------------
# - User defined -------------------------
# ----------------------------------------
setenv CASE 100ma
setenv GRID grid.100ma.yymmdd.pop.da
setenv KMT kmt.100ma.yymmdd.da
setenv TOOLSDIR  /your/setup_tools/base/dir/here
setenv WKDIR  /your/working/dir/here

setenv EXEDIR  $WKDIR/makeocn
if !( -d $EXEDIR) mkdir -p $EXEDIR
cd $EXEDIR

setenv CSMROOT  /your/ccsm/code/base/here/ccsm3_0_1
setenv CSMCODE  $CSMROOT/models
setenv CSMOCN   $CSMCODE/ocn/pop
setenv CSMICE   $CSMCODE/ice/csim4/src

#Set New Ocn/Ice Grid parameters:
set    NX = 100
set    NY = 116

# Set OCNGRID to new pop grid name 
setenv OCNGRID  100ma_x3

# ----------------------------------------
# - End User defined -------------------------
# ----------------------------------------
#Set up for making regionmask file:

setenv GRIDFILE  $WKDIR/$GRID   # or wherever your ocean grid resides... 
setenv KMTFILE   $WKDIR/$KMT    # or wherever your ocean kmt resides... 
setenv REGIONCODE $TOOLSDIR/ocn/regioncode


# Number of Ice categories:
# Don't change! (unless you really want to)
set    NCAT = 5

setenv ICEGRID  ${NX}x${NY}x${NCAT}

# OLDGRID is the pop grid name for input_template files to be copied
setenv OLDGRID  gx3v5 

  if ($OLDGRID == gx3v5) then
    set NXOLD = 100 
    set NYOLD = 116 
  endif

##########################################################################
#1) Make regionmask file region.ieeei4:

#get files for input:
 cp $GRIDFILE grid.pop.da
 cp $KMTFILE  kmt.da

#get region code, edit, compile and run:

cat >! commands.sed << EOF
s#NX#${NX}#
s#NY#${NY}#

EOF
 cp $REGIONCODE/modregmsk_edit.f .
 sed -f commands.sed modregmsk_edit.f >! modregmsk.f 

 f90 -o modregmsk modregmsk.f
 modregmsk

#put regionmask file in $WKDIR
 cp region.ieeei4 $WKDIR

##########################################################################
#copy over unchanged input_template files ice and ocn: 

foreach FILE (depth_accel history_contents pop_in \
              movie_contents scalar_contents tavg_contents \
              vert_grid )

cp $CSMOCN/input_templates/${OLDGRID}_$FILE $EXEDIR/${OCNGRID}_$FILE

end

#copy over the ones to change locally:
cp $CSMICE/input_templates/ice_model_size.F.${NXOLD}x${NYOLD}x5 ice_model_size.F 
cp $CSMOCN/input_templates/${OLDGRID}_model_size.F ocn_model_size.F 


##########################################################################

#Create new input files:
#Create region_ids
# Note: for negative valued region_ids (i.e. marginal seas), 
# you need to set a lat, lon location and area for the
# redistribution of net freshwater from the marginal sea
# (when marginal sea balance is turned on.)
# The example below has these set to zero.
# See user's guide for more info on how to set this.
   
cat >! region_ids << EOF
   1  'Southern Hemisphere '        0.0   0.0      0.0
   2  'Northern Hemisphere '        0.0   0.0      0.0

! $OCNGRID 

EOF

#Create transport_contents:
# This file is for diagnostic calculation of section transports.
# First line tells how many sections to integrate.
# Next lines are i,j,k limits of sections, whether
# section is meridional or zonal {(merid,zonal)} and a section name.
# Transport output appears in dt files.
# 

#imin imax jmin jmax kmin kmax sect   Name
cat >! transport_contents << EOF
3
  33   33    3   11    1   25 merid  Drake Passage
  95   95   20   41    1   25 merid  Indonesian Throughflow
  75   92   57   57    1   25 zonal  Tethys Seaway

  10   10   55   65    1   25 merid  TESTM
  45   55   10   10    1   25 zonal  TESTZ

  64   64    1  128    1   20 zonal  sample zonal section
   1  192   64   64    1   10 merid  sample meridional section

EOF

#END OF USER EDITING...


#using sed, new NX,NY, create model_size.F for ice and ocn
cat >! commands.sed << EOF
s#${NXOLD}#${NX}#
s#${NYOLD}#${NY}#

EOF

sed -f commands.sed ocn_model_size.F >! model_size.F 
sed -f commands.sed ice_model_size.F >! ice_size.F 

#s/cp new files over to new input_templates
foreach FILE (region_ids model_size.F transport_contents)
 cp $FILE ${OCNGRID}_$FILE
end
 cp ice_size.F ice_model_size.F.${NX}x${NY}x${NCAT}

exit(0)
