#!/bin/csh -fv 

set echo
set verbose
###################################################################
# Required input file:  
# topography/bathymetry file at .5x.5 degree resolution.
# This can be obtained from the 2x2 degree resolution data
# using create.05deg.ncl in this ocn/src/gridgen.
# usage:  % ncl create.05degree.ncl
# be sure to compile code in src dir and place executable in bin dir 
# makefile for ocean code found in ocn/bin

###################################################################
#Define global variables:

set MYDIR = /your/setup_tools/base/dir/here 
set CASE  = 100ma
set ITER   = 1   			# iteration 
set TOPO  = 100ma_topo_05_yymmdd.nc
set DATE  = "`date +%y%m%d`"

setenv TOOLSDIR $MYDIR
setenv DATADIR  $TOOLSDIR/ocn/data
setenv RUNDIR   /your/working/dir/here
setenv MYDATA   /your/working/dir/data   # cp topo data here

if ( (! -e $MYDATA/$TOPO) ) then
	echo ''
	echo 'FATAL ERROR: topo file does not exist locally or in ' $MYDATA '. Create new file using create.05degree.ncl'
	exit
   endif
endif

###################################################################
# User changes:  For each new horizontal grid you must edit the following parameters:
###################################################################

# Change for your continent distribution 
# ncview your topo_0.5x0.5 map to see where to place the poles over land.
set lonnp   =  121   		# longitude of North Pole
set latnp   =   74   		# latitude  of North Pole
set lonsp   =   33   		# longitude of South Pole
set latsp   =  -84   		# latitude  of South Pole

# change iteratively after you look at your grid.
# Use these to adjust gridcell distribution so you don't have big
# cells in the N. Hem and small cells in the S. Hem, for example.
set nlatn   = 63   		# number of j grid lines in NH
set nlats   = 53   		# number of j grid lines in SH

# Don't change without a good reason.
set nx      = 100  		# number of i grid lines
set nz      = 25		# number of vertical grid levels
set dyeq    = .6   		# dy in degrees at Equator
set dsig    = 15.  		# Gaussian efold-scale at equator
set jcon    = 11    		# jcon = # rows of constant dy at poles

# Don't change
set popgrid = grid.$ITER.pop.da	# binary grid file
set pltgrid = grid.$ITER.plot.da	# binary grid file
set cdfgrid = gridkmt.$ITER.nc		# netcdf grid file
set depgrid = h.$ITER.da		# binary depth array
set kmtgrid = kmt.$ITER.da		# binary kmt file
set vrtgrid = gx3v5_vert_grid	# ascii vertical grid input file
set topo     = $TOPO  	        # netcdf topography input dataset
set minz     = 5.		# min z in meters (Don't lower!!!)
set mink     = 3		# minimum allowed km value (Don't lower!!!)
@ ny      = $nlatn + $nlats  	# number of j grid lines

# not used
set iocean   = 50		# ocean (i,j) point used to define
set jocean   = 60		#	contiguous ocean.

# !!!SET PLOTTING VIEWPOINTS BELOW!!!

#################################
# SET HERE FILE INPUT
#################################

cat >! input.$ITER.ns_dipole << EOF
$nx $nlatn $nlats
$lonnp $latnp
$lonsp $latsp
$dyeq $dsig $jcon
1
$pltgrid
1
$popgrid
EOF

cat >! input.$ITER.paleotopo << EOF
$nx $ny $nz
$pltgrid
$vrtgrid
$topo
1
$depgrid
$minz
1
0
$mink
1
$kmtgrid
EOF

cat >! input.$ITER.grid_bin2nc << EOF
$nx
$ny
$cdfgrid
$vrtgrid
$kmtgrid
$pltgrid
$popgrid
EOF

#################################
#get input data:
ln -s $MYDATA/$TOPO .
cp $DATADIR/$vrtgrid . 
cp $DATADIR/$vrtgrid . 
cp $TOOLSDIR/ocn/bin/ns_dipole .
cp $TOOLSDIR/ocn/bin/paleotopo .
cp $TOOLSDIR/ocn/bin/grid_bin2nc .

#################################
# RUN GRID ROUTINES
# This must have been compiled. 
# Executable is copied into $RUNDIR.
#################################
ns_dipole < input.$ITER.ns_dipole  >! output.$ITER.ns_dipole
paleotopo < input.$ITER.paleotopo  >! output.$ITER.paleotopo
grid_bin2nc < input.$ITER.grid_bin2nc

#################################
# CLEAN UP
#################################
#/usr/bin/rm -f input.ns_dipole input.paleotopo input.display_hgrid_land

exit(0)
