C NCLFORTSTART
      subroutine near_neighbor(nlat,nlon,in_nlt,in_nln,
     1			       pct_wetland,landmask,
     2                         nnb_nlt,nnb_nln)         

      integer nlon,nlat               ! dimension (lat/lon) of grids
      integer in_nlt,in_nln           ! indices at current grid point  
      integer nnb_nlt,nnb_nln         ! nearest neighbor indices 
      integer landmask(nlon,nlat)
      real pct_wetland(nlon,nlat)
  
C NCLEND

      integer i,j,b,nbands

c find closest non-wetland nearest neighbor point to current indices
c start at location (1,-1) and search clockwise
c     ( 1,-1) ( 1,0) ( 1,1) 
c     ( 0,-1) ( 0,0) ( 0,1)
c     (-1,-1) (-1,0) (-1,1)
	 
	 i = in_nln + 1  ! start at current indices, note that	 
	 j = in_nlt + 1  ! fortran indices run from 1,n (not 0,n-1
		         ! as in ncl, need to add one to get into
			 ! correct index units)  
	 nbands = 15       ! number of bands to search around grid point 

	do b = 1, nbands
	  if(landmask(i+b,j-b).eq.1.and.
     1	     pct_wetland(i+b,j-b).eq.0.)then
	   nnb_nln = i+b
	   nnb_nlt = j-b
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100 
	  elseif(landmask(i+b,j).eq.1.and.
     1           pct_wetland(i+b,j).eq.0.)then
	   nnb_nln = i+b
	   nnb_nlt = j
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
  	   goto 100
	  elseif(landmask(i+b,j+b).eq.1.and.
     1           pct_wetland(i+b,j+b).eq.0.)then
	   nnb_nln = i+b
	   nnb_nlt = j+b
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100
	  elseif(landmask(i,j+b).eq.1.and.
     1           pct_wetland(i,j+b).eq.0.)then
	   nnb_nln = i
	   nnb_nlt = j+b
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100
	  elseif(landmask(i-b,j+b).eq.1.and.
     1           pct_wetland(i-b,j+b).eq.0.)then
	   nnb_nln = i-b
	   nnb_nlt = j+b
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100
	  elseif(landmask(i-b,j).eq.1.and.
     1           pct_wetland(i-b,j).eq.0.)then
	   nnb_nln = i-b
	   nnb_nlt = j
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100
	  elseif(landmask(i-b,j-b).eq.1.
     1           and.pct_wetland(i-b,j-b).eq.0.)then
	   nnb_nln = i-b
	   nnb_nlt = j-b
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100
	  elseif(landmask(i,j-b).eq.1.and.
     1           pct_wetland(i,j-b).eq.0.)then
	   nnb_nln = i
	   nnb_nlt = j-b
	   print *,' nearest neighbor found at nnb_nlt=',nnb_nlt,
     1		   ' nnb_nln=',nnb_nln
	   goto 100
	  else
           print *,' no non-wetland land points in band = ',b
	   print *,' incrementing bands and continuing search ' 
	  end if
	end do

100	continue

c	subtract index unit back off to convert back to ncl units
	nnb_nlt = nnb_nlt - 1
	nnb_nln = nnb_nln - 1



      return
      end
