
;======================================================================;
; read in template clm2 surface-data file
; makes modifications, writes out new file
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
external NEAR_NEIGHBOR "./near_neighbor.so"

begin

;====================user defined parameters

filename_template="surface-data.096x048_outofbox.nc"    
new_cdf ="surface-data.096x048_gx3Paleo.yymmdd.nc"
modtext =  "adjust to remove bogus wetlands where ocn/lnd grid mismatches"

;=============== read in all vars from clm template netcdf file
 
clm = addfile(filename_template,"r")
numlon  	   = clm->NUMLON
latixy  	   = clm->LATIXY
longxy  	   = clm->LONGXY
landmask           = clm->LANDMASK
landfrac           = clm->LANDFRAC
landfrac_pft       = clm->LANDFRAC_PFT
soil_color 	   = clm->SOIL_COLOR
pct_sand	   = clm->PCT_SAND
pct_clay	   = clm->PCT_CLAY
pct_wetland        = clm->PCT_WETLAND
pct_lake	   = clm->PCT_LAKE
pct_glacier    	   = clm->PCT_GLACIER
pct_urban	   = clm->PCT_URBAN
pft		   = clm->PFT
pct_pft	  	   = clm->PCT_PFT
monthly_lai	   = clm->MONTHLY_LAI
monthly_sai	   = clm->MONTHLY_SAI
monthly_height_top = clm->MONTHLY_HEIGHT_TOP
monthly_height_bot = clm->MONTHLY_HEIGHT_BOT


; dims....
dimslatlon = dimsizes(landmask)
dimslev    = dimsizes(pct_clay)
dimspft    = dimsizes(pft)
dimstime   = dimsizes(monthly_lai)
lsmlat = dimslatlon(0)
lsmlon = dimslatlon(1)
nlevsoi= dimslev(0)
lsmpft = dimspft(0)
time   = dimstime(0)
nchar = 128

print("lsmlat = " + lsmlat)
print("lsmlon = " + lsmlon)
print("nlevsoi = " + nlevsoi)
print("lsmpft = " + lsmpft)
print("time = " + time)
print("nchar = " + nchar)


;==========  mods here

   soil_color_new = soil_color
   pct_sand_new = pct_sand
   pct_clay_new = pct_clay
   pct_wetland_new = pct_wetland
   pct_lake_new = pct_lake
   pct_glacier_new = pct_glacier
   pct_urban_new = pct_urban
   pct_pft_new = pct_pft
   pft_new = pft
   monthly_lai_new = monthly_lai
   monthly_sai_new = monthly_sai
   monthly_height_top_new = monthly_height_top
   monthly_height_bot_new = monthly_height_bot


;--- adjust wetlands, give nearest neighbor value

 do nlt = 0, lsmlat -1
 do nln = 0, lsmlon -1
  nnb_nlt = nlt 
  nnb_nln = nln 
  if(pct_wetland(nlt,nln).gt.0.)then
   print(" point to change= " + nlt + " " + nln)
   NEAR_NEIGHBOR::near_neighbor(lsmlat,lsmlon,nlt,nln,\
                                pct_wetland,landmask,\
			        nnb_nlt,nnb_nln)
    soil_color_new(nlt,nln)   =  soil_color(nnb_nlt,nnb_nln)   
    pct_sand_new(:,nlt,nln)   =  pct_sand(:,nnb_nlt,nnb_nln) 
    pct_clay_new(:,nlt,nln)   =  pct_clay(:,nnb_nlt,nnb_nln) 
    pct_wetland_new(nlt,nln)=    pct_wetland(nnb_nlt,nnb_nln) 
    pct_lake_new(nlt,nln)   =    pct_lake(nnb_nlt,nnb_nln) 
    pct_glacier_new(nlt,nln)=    pct_glacier(nnb_nlt,nnb_nln) 
    pct_urban_new(nlt,nln)  =    pct_urban(nnb_nlt,nnb_nln) 
    pft_new(:,nlt,nln)      =    pft(:,nnb_nlt,nnb_nln) 
    pct_pft_new(:,nlt,nln)  =    pct_pft(:,nnb_nlt,nnb_nln)  
    monthly_lai_new(:,:,nlt,nln)	   = monthly_lai(:,:,nnb_nlt,nnb_nln) 
    monthly_sai_new(:,:,nlt,nln)	   = monthly_sai(:,:,nnb_nlt,nnb_nln) 
    monthly_height_top_new(:,:,nlt,nln)= monthly_height_top(:,:,nnb_nlt,nnb_nln)
    monthly_height_bot_new(:,:,nlt,nln)= monthly_height_bot(:,:,nnb_nlt,nnb_nln) 
  end if
 end do
 end do 

; perform check to make sure all points were modified
    check = pct_wetland_new
    do nlt = 0, lsmlat -1
    do nln = 0, lsmlon -1
     if(check(nlt,nln).gt.0)then
	print("nlt = "+ nlt + " nln= "+ nln + " diff= "+ check(nlt,nln))
     end if
    end do
    end do


;======== create skeleton file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new surface-data file....")

; define dimensions
dimNames = (/"lsmlon","lsmlat","nlevsoi","lsmpft","time","nchar"/)
dimSizes = (/ lsmlon, lsmlat, nlevsoi, lsmpft,  -1, nchar/)
dimUnlim = (/ False,  False,  False,   False,   True, False/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"NUMLON","integer",(/"lsmlat"/))
filevardef(cdf,"LONGXY","double",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LATIXY","double",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LANDMASK","integer",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LANDFRAC","double",(/"lsmlat","lsmlon"/))
filevardef(cdf,"LANDFRAC_PFT","double",(/"lsmlat","lsmlon"/))
filevardef(cdf,"SOIL_COLOR","integer",(/"lsmlat","lsmlon"/))
filevardef(cdf,"PCT_SAND","float",(/"nlevsoi","lsmlat","lsmlon"/))
filevardef(cdf,"PCT_CLAY","float",(/"nlevsoi","lsmlat","lsmlon"/))
filevardef(cdf,"PCT_WETLAND","float",(/"lsmlat","lsmlon"/))
filevardef(cdf,"PCT_LAKE","float",(/"lsmlat","lsmlon"/))
filevardef(cdf,"PCT_GLACIER","float",(/"lsmlat","lsmlon"/))
filevardef(cdf,"PCT_URBAN","float",(/"lsmlat","lsmlon"/))
filevardef(cdf,"PFT","integer",(/"lsmpft","lsmlat","lsmlon"/))
filevardef(cdf,"PCT_PFT","float",(/"lsmpft","lsmlat","lsmlon"/))
filevardef(cdf,"MONTHLY_LAI","float",(/"time","lsmpft","lsmlat","lsmlon"/))
filevardef(cdf,"MONTHLY_SAI","float",(/"time","lsmpft","lsmlat","lsmlon"/))
filevardef(cdf,"MONTHLY_HEIGHT_TOP","float",(/"time","lsmpft","lsmlat","lsmlon"/))
filevardef(cdf,"MONTHLY_HEIGHT_BOT","float",(/"time","lsmpft","lsmlat","lsmlon"/))

; write variables
cdf->NUMLON    		=  numlon
cdf->LONGXY    		=  longxy 
cdf->LATIXY    		=  latixy 
cdf->LANDMASK  		=  landmask 
cdf->LANDFRAC  		=  landfrac 
cdf->LANDFRAC_PFT 	=  landfrac_pft 
cdf->SOIL_COLOR   	=  soil_color 
cdf->PCT_SAND   	=  pct_sand 
cdf->PCT_CLAY   	=  pct_clay 
cdf->PCT_WETLAND   	=  pct_wetland 
cdf->PCT_LAKE   	=  pct_lake 
cdf->PCT_GLACIER   	=  pct_glacier 
cdf->PCT_URBAN   	=  pct_urban 
cdf->PFT	   	=  pft 
cdf->PCT_PFT	   	=  pct_pft 
cdf->MONTHLY_LAI   	=  monthly_lai 
cdf->MONTHLY_SAI   	=  monthly_sai 
cdf->MONTHLY_HEIGHT_TOP	=  monthly_height_top 
cdf->MONTHLY_HEIGHT_BOT	=  monthly_height_bot 

; add new text
cdf@Conventions   = clm@Conventions
cdf@History       = clm@History
cdf@Logname       = clm@Logname
cdf@Host	  = clm@Host
cdf@Source	  = clm@Source
cdf@Version 	  = clm@Version
cdf@Revision_Id   = clm@Revision_Id
cdf@Run_mode      = clm@Run_mode
cdf@Template      = filename_template 
cdf@createdby     = "ccsm_clm2_surface_create.ncl" 
cdf@Modifications = modtext

print("New file skeleton has been written...")

;========== delete oldvar from new file and write out new
;           variable
print("deleting old values, new ones writing...")

delete(cdf->SOIL_COLOR)
delete(cdf->PCT_SAND)
delete(cdf->PCT_CLAY)
delete(cdf->PCT_WETLAND)
delete(cdf->PCT_LAKE)
delete(cdf->PCT_GLACIER)
delete(cdf->PCT_URBAN)
delete(cdf->PFT)
delete(cdf->PCT_PFT)
delete(cdf->MONTHLY_LAI)
delete(cdf->MONTHLY_SAI)
delete(cdf->MONTHLY_HEIGHT_TOP)
delete(cdf->MONTHLY_HEIGHT_BOT)

cdf->SOIL_COLOR 	=  soil_color_new 
cdf->PCT_SAND   	=  pct_sand_new 
cdf->PCT_CLAY   	=  pct_clay_new 
cdf->PCT_WETLAND   	=  pct_wetland_new 
cdf->PCT_LAKE   	=  pct_lake_new 
cdf->PCT_GLACIER   	=  pct_glacier_new 
cdf->PCT_URBAN   	=  pct_urban_new 
cdf->PFT 	   	=  pft_new
cdf->PCT_PFT 	   	=  pct_pft_new
cdf->MONTHLY_LAI	=  monthly_lai_new
cdf->MONTHLY_SAI	=  monthly_sai_new
cdf->MONTHLY_HEIGHT_TOP =  monthly_height_top_new
cdf->MONTHLY_HEIGHT_BOT =  monthly_height_bot_new

print(new_cdf + " has been written")

end
    


