;======================================================================;
; reads in cret (80Ma) topo ascii file
; read in cret ocn (Netcdf) file 
; merges the two files, create netcdf file,  and plots
; negative vaules represent ocn depths
; unit in meters
; 

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"


begin

;====================user defined parameters

filename     = getenv("RFILE")
case         = getenv("CASE")
plotname      = getenv("PLOTNAME")


;============== read atm ascii file
;2x2 resolution:

nlat = 90
nlon = 180

;=============== read in lat, lon, idir from rdirc file
print("Rdirc data being read from file:" + filename)

 lat   = new((/nlat/),float)
 lon   = new((/nlon/),float)
 lat = latGlobeFo(nlat,"lat","latitude","degrees_north")
 lon = lonGlobeFo(nlon,"lon","longitude","degrees_east")-180. 

 UR    = new((/nlat,nlon/),float)
 VR    = new((/nlat,nlon/),float)
 idirc = new((/nlat,nlon/),integer)

lat!0= "lat"
lat&lat = lat 
lon!0= "lon"
lon&lon = lon 

printVarSummary(lon)

;idirc:    0        1    2        3     4          5     6         7     8 
 U0    = (/0.,      0.,  1., sqrt(2.),  1.,        0.,  -1., -sqrt(2.), -1./)
 V0    = (/0., sqrt(2.), 1.,       0., -1., -sqrt(2.),  -1.,       0.,   1./)
;normalize:
 U    = U0/sqrt(2.) 
 V    = V0/sqrt(2.) 

ksoi=asciiread(filename,(/nlon*nlat,3/),"float")

print(" rdirc data read")

  id0      = floattointeger(ksoi(:,2))
  id       = onedtond(id0,(/nlat,nlon/))

do i=0, nlon-1
do j=0, nlat-1

  coslat = cos(lat(j)*2*3.14159265/360.)
  UA = (/U0(id(j,i))/)*coslat
  VA = (/V0(id(j,i))/)
  
  AMP = sqrt(UA*UA + VA*VA)
  if( AMP .ne. 0.) then
   UR(j,i) = UA/AMP
   VR(j,i) = VA/AMP
  else
   UR(j,i) = 0.
   VR(j,i) = 0.
  end if
 
end do
end do

UR!0 = "lat"
UR!1 = "lon"
UR&lat = lat
UR&lon = lon  

VR!0 = "lat"
VR!1 = "lon"
VR&lat = lat
VR&lon = lon  

;================= plot
print("Openging output file :" + plotname)
res = True
PSName= "ps"
wks = gsn_open_wks(PSName,plotname)        ; open a ncgm file

res@gsnPolar        = "NH"
res@vcRefMagnitudeF =  .35 
;res@vcPositionMode  = "ArrowTail" 
res@vcRefLengthF    = 0.004 
;res@vcLineArrowThicknessF = 0.4 
;res@vcLineArrowHeadMinSizeF = 0.001 
res@vcLineArrowHeadMaxSizeF = 0.005 
;res@vcMonoLineArrowColor  = False             ; multiple colors desired
res@vcMinDistanceF        = 0.01              ; thins arrows near pole
;res@vcGlyphStyle        = "CurlyVector"              ; thins arrows near pole
res@vcLineArrowColor      = "blue"
;res@gsnSpreadColors     = True       
res@gsnDraw         = False               ; Do not draw plot
res@gsnFrame        = False               ; Do not advance frome
res@mpFillOn        = False
res@mpOutlineOn     = False
res@mpMinLatF        = 55

resP = True
resP@gsnMaximize = True
res@gsnCenterString = case+" Runoff Vectors"

plt= new(1,graphic)
;plt(0) = gsn_csm_vector_map_polar(wks,UR,VR,res)
plt(0) = gsn_csm_vector_map_polar(wks,UR({55:90},:),VR({55:90},:),res)
gsn_panel(wks,plt,(/1,1/),resP)
print("Data plotted")

end
    
