% pft2patch.m
%
% 1) want pctpftavg(row,col,15) to become
% pft(10,row,col) and pct(10,row,col)
% 2) want *avg(row,col,15,12) to become
% *new(12,10,row,col)
% 3) want % to add up to 100%

% if running this script manually, as opposed to automatically through
% newsfcdata.m, then uncomment the following 3 lines to obtain data

load step2
ncload(fileInit,'landfrac')

pft = zeros(10,row,col);
pct = zeros(10,row,col);
hbot4d = zeros(12,10,row,col);
htop4d = zeros(12,10,row,col);
tlai4d = zeros(12,10,row,col);
tsai4d = zeros(12,10,row,col);

for j = 1:row
  for i = 1:col
    if landfrac(j,i) > 0               % look at land points only
      npatch = 0;                      % start counting patches
      for pftindex = 1:15
        if pctpftavg(j,i,pftindex) > 0 % look for pfts with non-zero cover
          npatch = npatch + 1;         % increment patch
          if npatch > 10               % error trap
            message = 'npatch > 10'
            pause                      % script will probably crash...
          end
          pct(npatch,j,i) = pctpftavg(j,i,pftindex);
          if pftindex == 15            % index for bare ground
            pft(npatch,j,i) = 0;
            hbot4d(:,npatch,j,i) = 0;
            htop4d(:,npatch,j,i) = 0;
            tlai4d(:,npatch,j,i) = 0;
            tsai4d(:,npatch,j,i) = 0;
          else
            pft(npatch,j,i) = pftindex;
            hbot4d(:,npatch,j,i) = hbotavg(j,i,pftindex,:);
            htop4d(:,npatch,j,i) = htopavg(j,i,pftindex,:);
            tlai4d(:,npatch,j,i) = tlaiavg(j,i,pftindex,:);
            tsai4d(:,npatch,j,i) = tsaiavg(j,i,pftindex,:);
          end
        end
      end                              % pftindex loop
      if sum(pct(:,j,i)) == 0          % look for cells that ended up w/ 0
        npatch = npatch + 1;           % increment patch
        if npatch ~= 1                 % error trap
          message = 'this does not look right'
          npatch
          pause
        end
        pct(npatch,j,i) = 100;
        pft(npatch,j,i) = 0;           % redundant (I think)
      end % sum(pct) == 0
    end % landfrac > 0
  end % i loop
end % j loop

save step3 pft pct tlai4d tsai4d htop4d hbot4d

% write out new variables to surface-data file by reading in old surface data file
% and writing it out again, replacing the old values with the new ones calculated from
% the DGVM.  Be sure to copy your original surface-dataset file
 
 ncload(sfcfile,'PFT','PCT_PFT','MONTHLY_LAI','MONTHLY_SAI','MONTHLY_HEIGHT_TOP','MONTHLY_HEIGHT_BOT');
 PFT = pft;
 PCT_PFT =  pct;		% pct_pft
 MONTHLY_LAI =  tlai4d;
 MONTHLY_SAI =  tsai4d; 
 MONTHLY_HEIGHT_BOT =  hbot4d;
 MONTHLY_HEIGHT_TOP =  htop4d;

 ncsave(sfcfile,'PFT','PCT_PFT','MONTHLY_LAI','MONTHLY_SAI','MONTHLY_HEIGHT_TOP','MONTHLY_HEIGHT_BOT');


