% pft2patch.m
%
% 1) want pctpftavg(48,96,15) to become
% pft(10,48,96) and pct(10,48,96)
% 2) want *avg(48,96,15,12) to become
% *new(12,10,48,96)
% 3) want % to add up to 100%

% if running this script manually, as opposed to automatically through
% newsfcdata.m, then uncomment the following 3 lines to obtain data

load step2
file='b30.140vx.clm2.h1.0324-12.nc';
ncload(file,'landfrac')

pft = zeros(10,48,96);
pct = zeros(10,48,96);
hbot4d = zeros(12,10,48,96);
htop4d = zeros(12,10,48,96);
tlai4d = zeros(12,10,48,96);
tsai4d = zeros(12,10,48,96);

for j = 1:48
  for i = 1:96
    if landfrac(j,i) > 0               % look at land points only
      npatch = 0;                      % start counting patches
      for pftindex = 1:15
        if pctpftavg(j,i,pftindex) > 0 % look for pfts with non-zero cover
          npatch = npatch + 1;         % increment patch
          if npatch > 10               % error trap
            message = 'npatch > 10'
            pause                      % script will probably crash...
          end
          pct(npatch,j,i) = pctpftavg(j,i,pftindex);
          if pftindex == 15            % index for bare ground
            pft(npatch,j,i) = 0;
            hbot4d(:,npatch,j,i) = 0;
            htop4d(:,npatch,j,i) = 0;
            tlai4d(:,npatch,j,i) = 0;
            tsai4d(:,npatch,j,i) = 0;
          else
            pft(npatch,j,i) = pftindex;
            hbot4d(:,npatch,j,i) = hbotavg(j,i,pftindex,:);
            htop4d(:,npatch,j,i) = htopavg(j,i,pftindex,:);
            tlai4d(:,npatch,j,i) = tlaiavg(j,i,pftindex,:);
            tsai4d(:,npatch,j,i) = tsaiavg(j,i,pftindex,:);
          end
        end
      end                              % pftindex loop
      if sum(pct(:,j,i)) == 0          % look for cells that ended up w/ 0
        npatch = npatch + 1;           % increment patch
        if npatch ~= 1                 % error trap
          message = 'this does not look right'
          npatch
          pause
        end
        pct(npatch,j,i) = 100;
        pft(npatch,j,i) = 0;           % redundant (I think)
      end % sum(pct) == 0
    end % landfrac > 0
  end % i loop
end % j loop

save step3 pft pct tlai4d tsai4d htop4d hbot4d
