% newsfcdata.m
%
% avg 10 years of output from simulation b30.140vx and
% modify surface-data to perform b30.140g, a prescribed veg run

  file='b30.140vx.clm2.h1.0324-12.nc';
  ncload(file,'area','landfrac') % landfrac used in pft2patch.m

% initialize variables

  year1 = 324;
  year2 = 333;
  years = year2 - year1 + 1;

  tlai = zeros(12,16064); % months x total patches
  tsai = zeros(12,16064);
  htop = zeros(12,16064);
  hbot = zeros(12,16064);

  tlai5d = zeros(size(area,1),size(area,2),15,12,years); % j,i,pch,mo,yr
  tsai5d = zeros(size(area,1),size(area,2),15,12,years);
  htop5d = zeros(size(area,1),size(area,2),15,12,years);
  hbot5d = zeros(size(area,1),size(area,2),15,12,years);
  pctpft = zeros(size(area,1),size(area,2),15,years);

  for yr = 1:years

% define the file names to be read

    if yr + year1 - 1 < 100
      fileh1 = sprintf('b30.140vx.clm2.h1.00%d',yr+year1-1);
      if yr + year1 -1 == 91
        file=sprintf('b30.140vx.clm2.hv.00%d-01-01-00000.nc',yr+year1-1)
      else
        file=sprintf('b30.140vx.clm2.hv.00%d-01-01-00000.nc',yr+year1-1)
      end
    elseif yr + year1 - 1 < 1000
      fileh1 = sprintf('b30.140vx.clm2.h1.0%d',yr+year1-1);
      file = sprintf('b30.140vx.clm2.hv.0%d-01-01-00000.nc',yr+year1-1)
    end
    for mo = 1:12
      if mo < 10
        fileh12 = sprintf('-0%d.nc',mo);
      else
        fileh12 = sprintf('-%d.nc',mo);
      end
      filem = [fileh1 fileh12]

% read monthly data and reassign

      ncload(filem,'TLAI','TSAI','HTOP','HBOT')
      tlai(mo,:) = TLAI(1,:);
      tsai(mo,:) = TSAI(1,:);
      htop(mo,:) = HTOP(1,:);
      hbot(mo,:) = HBOT(1,:);
    end  % month loop
    v2xy % (not the script in /matlab) returns 4d variables used below

% read annual data

    ncload(file,'PFT','FPCGRID')
%   sumfpc(:,:) = sum(FPCGRID,1);                      % begin diagnostic
%   sumpft(:,:) = sum(PFT,1);
%   [pftj,pfti] = find(sumpft < 9999);
%   for i = 1:length(pfti)
%     if abs(sumfpc(pftj(i),pfti(i))-100) > 1e-6 & ... % check "vegetated" pts
%        abs(sumfpc(pftj(i),pfti(i))-0)   > 1e-6       % + 0% "vegetated" pts
%       sumfpc(pftj(i),pfti(i))                        % eg 100% glacier pts
%       pftj(i)
%       pfti(i)
%       pause
%     end
%   end                                                % end diagnostic

% go from patch indexed data to pft indexed data

    for patch = 1:10
      pft2d(:,:) = PFT(patch,:,:);
      pct2d(:,:) = FPCGRID(patch,:,:);
      for pftindex = 1:15 % bare grnd gets pft index 15
        if pftindex == 15 % b/c loop may not begin with 0
          [pftj,pfti] = find(pft2d == 0 & pct2d > 0);
        else
          [pftj,pfti] = find(pft2d == pftindex);
        end
        for i = 1:length(pfti)
          pctpft(pftj(i),pfti(i),pftindex,yr)  =pct2d(pftj(i),pfti(i));
          tlai5d(pftj(i),pfti(i),pftindex,:,yr)=tlai4d(:,patch,pftj(i),pfti(i));
          tsai5d(pftj(i),pfti(i),pftindex,:,yr)=tsai4d(:,patch,pftj(i),pfti(i));
          htop5d(pftj(i),pfti(i),pftindex,:,yr)=htop4d(:,patch,pftj(i),pfti(i));
          hbot5d(pftj(i),pfti(i),pftindex,:,yr)=hbot4d(:,patch,pftj(i),pfti(i));
        end
      end % pft index loop
    end % patch loop
  end % year loop

  clear tlai tsai htop hbot TLAI TSAI HTOP HBOT FPCGRID PFT

  if min(min(min(min(pctpft)))) < 0         % error check
    message = 'min pctpft < 0!!!'
    pause                                   % stop run here
  end
  pctpftavg = mean(pctpft,4);               % 10-yr average of percent cover

  save step1 *5d pctpft*

% next run newsfcdata2...
