% newsfcdata2.m
%
% second step in the process started by newsfcdata1.m

% load step1 % com. out if running immediately after newsfcdata1.m

  row = size(lat);
  col = size(lon);

  tlaiavg = zeros(row,col,15,12);
  tsaiavg = zeros(row,col,15,12);
  htopavg = zeros(row,col,15,12);
  hbotavg = zeros(row,col,15,12);

  for mo = 1:12                             % 20-yr avg of others is more work
    tmp(:,:,:,:) = tlai5d(:,:,:,mo,:);      % j,i,pftindex,yr
    tmp = tmp .* pctpft;                    % grid avg *100 of same variable
    tlaiavg(:,:,:,mo) = mean(tmp,4);        % 20-yr avg *100 for each month

    tmp(:,:,:,:) = tsai5d(:,:,:,mo,:);
    tmp = tmp .* pctpft;
    tsaiavg(:,:,:,mo) = mean(tmp,4);

    tmp(:,:,:,:) = htop5d(:,:,:,mo,:);
    tmp = tmp .* pctpft;
    htopavg(:,:,:,mo) = mean(tmp,4);

    tmp(:,:,:,:) = hbot5d(:,:,:,mo,:);
    tmp = tmp .* pctpft;
    hbotavg(:,:,:,mo) = mean(tmp,4);

  end % we have grid average values, so we must go back to the patch level

  message = 'done month loop; start pftindex loop'

  for pftindex = 1:15
    pctpftavg2d(:,:) = pctpftavg(:,:,pftindex);
    [zj,zi] = find(pctpftavg2d == 0); % if no error, comment out 12 lines
    for i = 1:length(zi)
      for mo = 1:12 % error check
        if tlaiavg(zj(i),zi(i),pftindex,mo) > 0 | ...
           tsaiavg(zj(i),zi(i),pftindex,mo) > 0 | ...
           htopavg(zj(i),zi(i),pftindex,mo) > 0 | ...
           hbotavg(zj(i),zi(i),pftindex,mo) > 0
          message = 'tlai, tsai, htop, or hbotavg > 0 for pctpftavg = 0. WHY?'
          pause     % stop run here
        end
      end
    end % error check
    [gzj,gzi] = find(pctpftavg2d > 0);
    for i = 1:length(gzi)
      tlaiavg(gzj(i),gzi(i),pftindex,:) = tlaiavg(gzj(i),gzi(i),pftindex,:)...
                                        / pctpftavg(gzj(i),gzi(i),pftindex);
      tsaiavg(gzj(i),gzi(i),pftindex,:) = tsaiavg(gzj(i),gzi(i),pftindex,:)...
                                        / pctpftavg(gzj(i),gzi(i),pftindex);
      htopavg(gzj(i),gzi(i),pftindex,:) = htopavg(gzj(i),gzi(i),pftindex,:)...
                                        / pctpftavg(gzj(i),gzi(i),pftindex);
      hbotavg(gzj(i),gzi(i),pftindex,:) = hbotavg(gzj(i),gzi(i),pftindex,:)...
                                        / pctpftavg(gzj(i),gzi(i),pftindex);
    end
  end

  save step2 *avg
  clear pctpft *5d
% pft2patch % start this script manually after checking sum(pctpftavg,3)!!!
