% newsfcdata.m
%
% avg 10 years of output from simulation b30.140vx and
% modify surface-data to perform b30.140g, a prescribed veg run

  % WARNING:  be sure to copy your original surface data file to another name.
  % the surface data file will be overwritten in the 3rd step of this process (pft2patch.m)

  sfcfile = '/ptmp/nanr/lgm-jf/fenghe/surface-data.b30.22_0kaDVT_10ext.dgvm.nc';

  fname = 'b30.22_0kaDVT_10ext.clm2'
  path  = '/ptmp/nanr/lgm-jf/fenghe/hist/'

  year1 =  991;		
  year2 = 1000;

  if year1 < 100
      useYear = sprintf('00%d',year1);
      fileh1 = [path fname '.h1.' useYear];
  elseif year1 < 1000
      useYear = sprintf('0%d',year1);
      fileh1 = [path fname '.h1.' useYear];
  end
  fileh12 = '-01.nc'
  fileInit = [fileh1 fileh12]
  ncload(fileInit,'TLAI','area','landfrac','lat','lon') % landfrac used in pft2patch.m; TLAI used to get npft
  npft = size(TLAI,2)


% initialize variables

  years = year2 - year1 + 1;

  tlai5d = zeros(size(area,1),size(area,2),15,12,years); % j,i,pch,mo,yr
  tsai5d = zeros(size(area,1),size(area,2),15,12,years);
  htop5d = zeros(size(area,1),size(area,2),15,12,years);
  hbot5d = zeros(size(area,1),size(area,2),15,12,years);
  pctpft = zeros(size(area,1),size(area,2),15,years);

  for yr = 1:years

% define the file names to be read

    % h1 files 
    if yr + year1 - 1 < 100
      useYear = sprintf('00%d',yr+year1-1);
      fileh1 = [path fname '.h1.' useYear];
    elseif yr + year1 - 1 < 1000
      useYear = sprintf('0%d',yr+year1-1);
      fileh1 = [path fname '.h1.' useYear];
    elseif yr + year1 -1 < 10000
      useYear = sprintf('%d',yr+year1-1);		% hv files indexed year+1
      fileh1 = [path fname '.h1.' useYear];
    end
    % hv files indexing
    if yr + year1 < 100
      useYear = sprintf('00%d',yr+year1);		% hv files start at index+1 year
      filehv = [path fname '.hv.' useYear '-01-01-00000.nc'];
    elseif yr + year1 < 1000
      useYear = sprintf('0%d',yr+year1);		% hv files indexed year+1
      filehv = [path fname '.hv.' useYear '-01-01-00000.nc'];
    elseif yr + year1 < 10000
      useYear = sprintf('%d',yr+year1);		% hv files indexed year+1
      filehv = [path fname '.hv.' useYear '-01-01-00000.nc'];
    end
    % read npft from random h1 file
    tlai = zeros(12,npft); % months x total patches
    tsai = zeros(12,npft);
    htop = zeros(12,npft);
    hbot = zeros(12,npft);
    for mo = 1:12
      if mo < 10
        fileh12 = sprintf('-0%d.nc',mo);
      else
        fileh12 = sprintf('-%d.nc',mo);
      end
      filem = [fileh1 fileh12];

% read monthly data and reassign

      ncload(filem,'TLAI','TSAI','HTOP','HBOT');
      tlai(mo,:) = TLAI(1,:);
      tsai(mo,:) = TSAI(1,:);
      htop(mo,:) = HTOP(1,:);
      hbot(mo,:) = HBOT(1,:);
    end  % month loop
    v2xy % (not the script in /matlab) returns 4d variables used below

% read annual data

    ncload(filehv,'PFT','FPCGRID')
%   sumfpc(:,:) = sum(FPCGRID,1);                      % begin diagnostic
%   sumpft(:,:) = sum(PFT,1);
%   [pftj,pfti] = find(sumpft < 9999);
%   for i = 1:length(pfti)
%     if abs(sumfpc(pftj(i),pfti(i))-100) > 1e-6 & ... % check "vegetated" pts
%        abs(sumfpc(pftj(i),pfti(i))-0)   > 1e-6       % + 0% "vegetated" pts
%       sumfpc(pftj(i),pfti(i))                        % eg 100% glacier pts
%       pftj(i)
%       pfti(i)
%       pause
%     end
%   end                                                % end diagnostic

% go from patch indexed data to pft indexed data

    for patch = 1:10
      pft2d(:,:) = PFT(patch,:,:);
      pct2d(:,:) = FPCGRID(patch,:,:);
      for pftindex = 1:15 % bare grnd gets pft index 15
        if pftindex == 15 % b/c loop may not begin with 0
          [pftj,pfti] = find(pft2d == 0 & pct2d > 0);
        else
          [pftj,pfti] = find(pft2d == pftindex);
        end
        for i = 1:length(pfti)
          pctpft(pftj(i),pfti(i),pftindex,yr)  =pct2d(pftj(i),pfti(i));
          tlai5d(pftj(i),pfti(i),pftindex,:,yr)=tlai4d(:,patch,pftj(i),pfti(i));
          tsai5d(pftj(i),pfti(i),pftindex,:,yr)=tsai4d(:,patch,pftj(i),pfti(i));
          htop5d(pftj(i),pfti(i),pftindex,:,yr)=htop4d(:,patch,pftj(i),pfti(i));
          hbot5d(pftj(i),pfti(i),pftindex,:,yr)=hbot4d(:,patch,pftj(i),pfti(i));
        end
      end % pft index loop
    end % patch loop
  end % year loop

  clear tlai tsai htop hbot TLAI TSAI HTOP HBOT FPCGRID PFT

  if min(min(min(min(pctpft)))) < 0         % error check
    message = 'min pctpft < 0!!!'
    pause                                   % stop run here
  end
  pctpftavg = mean(pctpft,4);               % 10-yr average of percent cover

  save step1 *5d pctpft*

% next run newsfcdata2...
