
;======================================================================;
; reads in an h1 file and creates file "ijk.ascii" required for sam's
; dgvm -> static veg tool (for surface_data setts). 
; cshields, apr08 
; 

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

external IJK_ASCII "/fis/cgd/ccr/paleo/setup_tools/dgvm2static_tool/ijk_ascii.breeze.080822.so"

begin

FPATH = "/ptmp/nanr/lgm-jf/fenghe/hist/"

; ================================>  ; PARAMETERS
h1file = FPATH + "b30.22_0kaDVT_10ext.clm2.h1.1000-12.nc"  		; use last month in 10yr extension

h1 = addfile(h1file,"r")

ixy  = h1->pfts1d_ixy  
jxy  = h1->pfts1d_jxy  
k = dimsizes(ixy)
print(k)
printVarSummary(ixy)
printVarSummary(jxy)

;==== print out ascii file 
count = 0
do nk = 0, k-1
 count = count + 1
;  print("      "+ ixy(nk) + "      " + jxy(nk) + "      " + count)  
end do

IJK_ASCII::ijk_ascii(ixy,jxy,k)

end
    


