#!/bin/csh -f
set echo
set verbose
#----------------------- rdirc.csh --------------------------------------
# Revised - April 2007 - nanr
# -------------------------------------------------------------------
#
# this cshell script runs the program topo2rdirc.F90 
#
# -------------------------------------------------------------------
# Notes
# -------------------------------------------------------------------
# Start with topography and end with river directions map.
# Simpler procedure than Graham et al. (1999), because
# we have no idea where the rivers were in the geologic past.
#
# The output consists of two ascii files: fort.10 and fort.11.
# The former is the river directions map in the format required by CLM.
# The latter lists all grid cells involved in infinite river loops.
# The user must redirect rivers in the vicinity of infinite loops.
# Alternatively, the user may start with topography which always slopes to
# the ocean, doesn't have internal basins, and doesn't contain completely
# flat plateaus.
#
# Currently written for Cretaceous topography.
#
# slevis, feb 2003
#
#-----------------------------------------------------------------
# YOU NEED  : Makefile,topo2rdirc_sed.F90,rdirc.csh
# TO RUN    : rdirc.csh
# NOTE      : make sure "limits" on your machine are set appropriately
#           : if not set large enough, the program may not have enough
#             space/memory to run
#-----------------------------------------------------------------
#
#----------------------------------------------------------------------------
# specify input/output pathnames with enviromental variables set in this script 
#----------------------------------------------------------------------------

set INFILE  = 100ma_topo_2x2_yymmdd.nc
set CASE   = 100ma
set TOOLSDIR        = /your/setup_tools/dir/here

#----------------------------------------------------------------------------
set SRCDIR          = $TOOLSDIR/lnd/src/rdirc
set RUNDIR          = /your/working/dir/here
set INPUT_TOPO_DATA = /your/data/here/$INFILE

# output fort.10 and fort.11 will in working directory 
#----------------------------------------------------------------------------
# use "sed" to insert pathnames into fortran code 
#----------------------------------------------------------------------------

cat >! pathname.sed << EOF
s#input_topo_data#$INFILE#
EOF
cp  $SRCDIR/topo2rdirc_sed.F90 .
cp  $SRCDIR/topo2rdirc_sed.F90 topo2rdirc.F90 
sed -f pathname.sed topo2rdirc_sed.F90 >! topo2rdirc.F90

#----------------------------------------------------------------------------
#  compile and run 
#----------------------------------------------------------------------------
cp  $INPUT_TOPO_DATA . 
cp  $SRCDIR/Makefile.rdirc Makefile 
gmake EXENAME=topo2rdirc
topo2rdirc

#---------------------------------------------------------------
# cp fort.10 to original file to save 
cp fort.10 fort.10_orig
#----------------------------------------------------------------


exit



