#! /bin/csh -f

set echo
set verbose

#---------------------------------------------------------------------------
# Make a plot of runoff vectors from rdirc file: 
#---------------------------------------------------------------------------

#----------------------------------------------------------------------------
# Begin User Modify : specify input/output pathnames 
#----------------------------------------------------------------------------

set IFILE  = 100ma_topo_2x2_yymmdd.nc
set CASE   = 100ma
set TOOLSDIR  = /your/setup/tools/here
set WKDIR  = /your/working/dir/here
setenv CASE Cretaceous

#----------------------------------------------------------------------------
# End User Modify
#----------------------------------------------------------------------------

#directory to run this program:
setenv RUNDIR   $WKDIR

set DATADIR  = /your/data/here

# RFILE is the fort.10 output by $TOOLSDIR/lnd/scripts/rdirc.csh
setenv RFILE     $RUNDIR/fort.10_orig
setenv PLOTNAME  $DATADIR/rdirc_2x2_stereo 

#NCL Directory: 
setenv NCLDIR $TOOLSDIR/lnd/src/rdirc
#---------------------------------------------------------------------------
#  End of user input
#---------------------------------------------------------------------------
if !( -d $RUNDIR) mkdir -p $RUNDIR
cd $RUNDIR

cp $NCLDIR/rdirc_stereo.ncl .

#Run NCL plotting program:

ncl < rdirc_stereo.ncl

#---------------------------------------------------------------------------
exit(0)

