#! /bin/csh -f

set echo
set verbose

#---------------------------------------------------------------------------
# Make a plot of runoff vectors from rdirc file: 
#---------------------------------------------------------------------------
#----------------------------------------------------------------------------
# Begin User Modify : specify input/output pathnames 
#----------------------------------------------------------------------------

set IFILE  = 100ma_topo_2x2_yymmdd.nc
set CASE   = 100ma
set TOOLSDIR  = /your/setup_tools/base/here
set WKDIR  = /your/working/dir/here
setenv CASE Cretaceous

#----------------------------------------------------------------------------
# End User Modify
#----------------------------------------------------------------------------

#directory to run this program:
setenv EXEDIR   $WKDIR

set DATADIR  =  /your/data/here


# RFILE is the fort.10 output by $TOOLSDIR/lnd/scripts/rdirc.csh
setenv RFILE    $EXEDIR/fort.10_orig
setenv PLOTNAME $DATADIR/rdirc_2x2 

#NCL Directory: 
setenv NCLDIR $TOOLSDIR/lnd/src/rdirc
#---------------------------------------------------------------------------
#  End of user input
#---------------------------------------------------------------------------
if !( -d $EXEDIR) mkdir -p $EXEDIR
cd $EXEDIR

cp $NCLDIR/rdirc.ncl .

#Run NCL plotting program:

ncl < rdirc.ncl

#---------------------------------------------------------------------------
exit(0)

