#!/bin/csh -f
set echo
set verbose
#----------------------- paleo_mkraw.csh --------------------------------------
#
# Designed to run on bluevista (AIX)
#
# all work is done in current working directory
#
# this cshell script runs the program paleo_mkraw.F90 
#
# see code for details (comments)
# input:  
# input data: (2x2 netcdf) LSM vegetation types from desired period
#           : (mksrf_soitex.10level.nc) IGBP soil texture for 0k
#           : input file pathname specified below
# output data: raw data files necessary to create surface-data file
#              at model runtime: mksrf_glacier_paleo.nc
#                              : mksrf_urban_paleo.nc
#                              : mksrf_lanwat_paleo.nc
#                              : mksrf_soicol_paleo.nc
#                              : mksrf_pft_paleo.nc
#                              : mksrf_lai_paleo.nc
#                              : mksrf_soitex_paleo.nc
#-----------------------------------------------------------------
# YOU NEED  : Makefile,paleo_mkraw_sed.F90,paleo_mkraw.csh,input data
# TO RUN    : paleo_mkraw.csh
# NOTE      : make sure "limits" on your machine are set appropriately
#           : if not set large enough, the program may not have enough
#             space/memory to run
#-----------------------------------------------------------------
#
#----------------------------------------------------------------------------
# Begin User Modify:
# specify input/output pathnames with enviromental variables set in this script 
#----------------------------------------------------------------------------

# Copy this file into this directory.
setenv INFILE 100ma_sur_2x2_yymmdd.nc
setenv CASE   100ma
setenv TOOLSDIR /your/setup_tools_base/here
setenv SRCDIR /your/setup_tools_base/here/lnd/src
setenv DATADIR /your/data/here 

set DATE  = "`date +%y%m%d`"
set INFILE_FORMAT = netcdf		# [netcdf, ascii]

#----------------------------------------------------------------------------
# End User Modify
#----------------------------------------------------------------------------

#------------------------------------
# input file names:
#------------------------------------
# Land surface types:
set INPUT_LSM_DATA = $DATADIR/$INFILE

if (! (-e $INPUT_LSM_DATA)) then
	echo ' Copy LSM data into this directory and restart script'
	exit
endif

# Soil texture (Present Day):
set INPUT_SOI_DATA = $TOOLSDIR/lnd/data/mksrf_soitex.10level.nc

#------------------------------------
# output file names (write into local directory)
#------------------------------------

#NOTE: in setting the output filename, you may want to replace the
# text 'paleo' with a more descriptive text (ie, Cretaceous, LGM, 6.5ka, etc.).
#setting data output file names:
set OUTPUT_GLACIER = mksrf_glacier_$CASE.c$DATE.nc
set OUTPUT_URBAN   = mksrf_urban_$CASE.c$DATE.nc
set OUTPUT_LANWAT  = mksrf_lanwat_$CASE.c$DATE.nc
set OUTPUT_SOICOL  = mksrf_soicol_$CASE.c$DATE.nc
set OUTPUT_PFT     = mksrf_pft_$CASE.c$DATE.nc
set OUTPUT_LAI     = mksrf_lai_$CASE.c$DATE.nc
set OUTPUT_SOITEX  = mksrf_soitex_$CASE.c$DATE.nc

#----------------------------------------------------------------------------
# NO CHANGES BELOW THIS POINT
#----------------------------------------------------------------------------
# use "sed" to insert pathnames into fortran code 
#----------------------------------------------------------------------------

cat >! pathnames.sed << EOF
s#infile_format#$INFILE_FORMAT#
s#input_lsm_data#$INPUT_LSM_DATA#
s#input_soi_data#$INPUT_SOI_DATA#
s#output_glacier#$OUTPUT_GLACIER#
s#output_urban#$OUTPUT_URBAN#
s#output_lanwat#$OUTPUT_LANWAT#
s#output_soicol#$OUTPUT_SOICOL#
s#output_pft#$OUTPUT_PFT#
s#output_lai#$OUTPUT_LAI#
s#output_soitex#$OUTPUT_SOITEX#
EOF

ln -s  $DATADIR/$INFILE ./$INFILE
cp  Makefile.mkraw Makefile
cp  $SRCDIR/paleo_mkraw_sed.F90 . 
sed -f pathnames.sed paleo_mkraw_sed.F90 >! paleo_mkraw.F90

#----------------------------------------------------------------------------
#  compile and run 
#----------------------------------------------------------------------------
gmake EXENAME=paleo_mkraw
paleo_mkraw

exit
