#!/bin/csh -f
set echo
set verbose
#----------------------- check.csh --------------------------------------
#
# all work is done in directory where script and code resides 
#
# this cshell script runs the program check_inf_loop.F90 
#
# -------------------------------------------------------------------
# Notes
# -------------------------------------------------------------------
# This program is a check to make sure all inifinte loops have
# been corrected in fort.10 (generated by topo2rdirc.F90).
# Use this programs as many times as necessary on fort.10 to
# verify that all infinite loops are removed.
#
#input file: fort.10 
# is the river directions map in the format required by CLM.
#
#output file: fort.11 
# lists all grid cells involved in infinite river loops.
#
# The user must 'redirect' rivers in the vicinity of infinite loops.
# Alternatively, the user may start with topography which always slopes to
# the ocean, doesn't have internal basins, and doesn't contain completely
# flat plateaus.
# 
# To 'redirect' rivers use fort.11 to modify fort.10 by hand editing; 
# Be sure an original copy of fort.10 was saved.  
# This was done at the end of rdirc.csh.
#
#-----------------------------------------------------------------
# YOU NEED  : Makefile,check_inf_loop_sed.F90,check.csh
# TO RUN    : check.csh
# NOTE      : make sure "limits" on your machine are set appropriately
#           : if not set large enough, the program may not have enough
#             space/memory to run
#-----------------------------------------------------------------
#----------------------------------------------------------------------------
# Begin User Modify : specify input/output pathnames 
#----------------------------------------------------------------------------

set CASE   = 100ma
set TOOLSDIR = /your/setup/tools/here

#----------------------------------------------------------------------------
# End User Modify
#----------------------------------------------------------------------------

#directory to run this program:
setenv RUNDIR  /your/working/dir/here
setenv SRCDIR   $TOOLSDIR/lnd/src/rdirc
set INPUT_CHECK_DATA = $RUNDIR/fort.10

#----------------------------------------------------------------------------
# use "sed" to insert pathnames into fortran code 
#----------------------------------------------------------------------------
#run in current working directory:

cat >! cpathname.sed << EOF
s#input_check_data#$INPUT_CHECK_DATA#
EOF

cp  $SRCDIR/Makefile.rdirc .
cp  $SRCDIR/check_inf_loop_sed.F90 .
cp  $SRCDIR/check_inf_loop_sed.F90  check_inf_loop.F90 
sed -f cpathname.sed check_inf_loop_sed.F90 >! check_inf_loop.F90

#----------------------------------------------------------------------------
#  compile and run 
#----------------------------------------------------------------------------
gmake -f Makefile.rdirc EXENAME=check_inf_loop
check_inf_loop

exit

