; read in temp/salt timeseries computes global wgted avg 
; assumes data is annual
; c. shields, ncar


load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"  


begin

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; ================================>  ; PARAMETERS
case    = "b30.xxx"
varfile= "b30.xxx.pop.SALT.0001_cat_0999.nc"
ocngrid = "b30.xxx.grids.wgts.nc"
VAR = "SALT"    ; "TEMP", or "SALT"


plot_begin = 1 ;for clean timeline
plot_end = 999 

smooth = 0 ; 0 no 1 yes
dtrd = 0  ; 0 no 1 yes
nave = 20 ; number yrs in smoothing

ncwrite = 1  ; 0 no 1 yes

if(VAR.eq."SALT")then
 gname = "gsalt"
 gfile = case + "_gsalt_"+plot_begin+"-"+plot_end + ".nc"
else
 gname = "gtemp"
 gfile = case + "_gtemp_"+plot_begin+"-"+plot_end + ".nc"
end if

;=====> initial resource settings
PsName= "ps"
label = "400-2049" 
plotname =gname+label
wks = gsn_open_wks(PsName,plotname) ; Open a Postscript file

;===== var 
fvar = addfile(varfile, "r")
focn  = addfile(ocngrid, "r")
var0    = fvar->$VAR$
region_mask   = focn->REGION_MASK
delete(region_mask)

;==== var read other grid data (memory issues, need to break up)
vartime = fvar->time
z_t      = fvar->z_t
nzt      = dimsizes(z_t)
dz       = focn->dz
tarea    = focn->TAREA
tlat     = focn->TLAT
kmt      = focn->KMT
dims = dimsizes(tlat)
nlat = dims(0)
nlon = dims(1)
ntimes_var= dimsizes(vartime) 
print("nlat= "+nlat)
print("nlon= "+nlon)

;---compute ocean volumes 
vol_glo = new(nzt,float)
k = new((/nlat,nlon/),integer)
do n= 0,nzt-1
 k = n
 work = mask(tarea,k.lt.kmt,True) ;use areas were k<kmt
 vol_glo(n) = dz(n)*sum(work)       ;find volume for each model level   
end do
sumvol_glo = sum(vol_glo)
delete(work)

;--- compute area avgs
dtmp     = wgt_areaave2(var0,tarea,0)
dtmp!0 = "time"
dtmp!1 = "z_t"
dtmp&z_t = z_t
delete(var0)

;---- compute volume avgs 
gvar0 = new(ntimes_var,float)
do nt = 0,ntimes_var-1
 gvar0(nt) = dim_sum(dtmp(nt,:)*vol_glo)/sumvol_glo
end do
 
gvar0!0 = "time"
gvar0&time = vartime

if(dtrd.eq.1)then
 print("Detrending data...")
 gvar = dtrend(var0,False)
else
 gvar = gvar0
end if

delete(dtmp)
delete(gvar0)

print("global volume SALT computed")

;==== make more plottable timeline...

years = ispan(plot_begin,plot_end,1)
nyrs = dimsizes(years)
if(nyrs.ne.ntimes_var)then
 print("plot index does not match data timeline")
 exit
end if

;=========> perform smoothing

if(smooth.eq.1)then
 gvar = runave_Wrap(gvar,nave,0)
end if

;=================GRAPHICS

plotxy = new(2,graphic)
resP = True
resP@gsnMaximize = True

;-----  global var 
xyres = True
xyres@gsnFrame = False
xyres@gsnDraw = False
xyres@vpHeightF = .23 ;.18;.23 ;.30
xyres@vpWidthF =  .783
xyres@tiXAxisFontHeightF = .015 ;0.010        ; default is 0.02
xyres@tiYAxisFontHeightF = .015 ;0.010        ; default is 0.02
xyres@tmYLLabelFontHeightF =.015 ; 0.010        ; default is 0.02
xyres@tmXBLabelFontHeightF = .015 ;0.010        ; default is 0.02
xyres@gsnLeftString = " "
xyres@gsnRightString = " "
xyres@xyLineColor = (/"black"/)
xyres@gsnCenterString =  "Global Salt (psu)" 
xyres@tiYAxisString = "Salinity (psu)"
plotxy(0)  = gsn_csm_xy (wks,years,gvar,xyres)

gsn_panel(wks,plotxy,(/1,1/),resP)
print("Plotting xy")


;============== write netcdf file

if(ncwrite.eq.1)then
 gvar!0 = "time"
 gvar&time = years 
 dimNames = (/ "time"/) ; Specify output dimensions
 dimSizes = (/  -1 /)
 dimUnlim = (/  True  /)
 fnc  = addfile ( gfile , "c" )      ; open the output file
 filedimdef (fnc, dimNames,dimSizes,dimUnlim)
 fnc->$gname$  = gvar
 fnc->time = years 
 fnc@source = case + " " + varfile 
 print(case + "  data written to nc")
end if


end

