;*************************************************
; extract mask from coupler mapping file  
;*************************************************
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
;************************************************
begin
;************************************************
; read in netCDF file
;************************************************
; Edit the name of the grid or map file:
  gfile = addfile("map_gx3Paleo_to_T31_040122_bilin_da.nc","r")

;edit the ni (=imt) and ny (=jmt) size of the 2D array
  ni = 100  
  nj = 116  

;edit the name of the read mask: 

;for map_*files:
  imask1 = gfile->mask_a

;for grid file output from myconvertPOPT:
; imask1 = gfile->grid_imask

  imaskn = onedtond(imask1,(/nj,ni/))

;Edit the name of the output file:
ncdf = addfile ("xygrid_mapfile.nc", "c")
  ncdf->imask = imaskn

end
