FUNCTION delete_elements, array, index
; deletes array elements array[index[]] from array
;
; returns array with dimension reduced by size of index[]

adim = (size(array))(0)
idim = (size(index))(0)
if (adim NE 1) then message,"Can only handle 1-D arrays..."
if (idim NE 1) then message,"Can only handle 1-D arrays..."

asize = (size(array))(1)
isize = (size(index))(1)

if (min(index) LT 0) then message,"index LT 0"
if (max(index) GT asize-1) then message,"index exceeds array dimensions"

mask = replicate(1,asize)
ind = lindgen(asize)

for i=0,isize-1 do begin
  del = where(ind EQ index[i])
  mask[del] = 0
endfor

keep = where(mask EQ 1)
tmp = array[keep]
return,tmp

end
