#!/bin/csh -fv 
#===============================================================================
# This scrip will test SCRIP/CCSM area-average and bilinear mapping data files
# using test code provided along with the SCRIP source code distribution
# 
# This script assumes
# 1) that the scrip source code has already been compiled appropriately
# 2) that the mapping data files already exist
#===============================================================================

set echo off
set verbose

#-------------------------------------------------------------------------------
# edit these csh vars to define what mapping files will be created
#-------------------------------------------------------------------------------

set MAPDIR     = /your/mapping/dirs/here/cpl/work
set SCRIPDIR   = /your/scrip1.4/dirs/here

#--- mapping files: input data to test ---
set mapFn_o2a_aavg   = $MAPDIR/map_gx3Paleo_to_T31_aave_da.nc
set mapFn_a2o_aavg   = $MAPDIR/map_T31_to_gx3Paleo_aave_da.nc
set mapFn_o2a_bilin  = $MAPDIR/map_gx3Paleo_to_T31_bilin_da.nc
set mapFn_a2o_bilin  = $MAPDIR/map_T31_to_gx3Paleo_bilin_da.nc

#--- script_test output files: output data derived from input files ---
set outFn_o2a_aavg   = $MAPDIR/map_gx3Paleo_to_T31_aave_da_diag.nc
set outFn_a2o_aavg   = $MAPDIR/map_T31_to_gx3Paleo_aave_da_diag.nc
set outFn_o2a_bilin  = $MAPDIR/map_gx3Paleo_to_T31_bilin_da_diag.nc
set outFn_a2o_bilin  = $MAPDIR/map_T31_to_gx3Paleo_bilin_da_diag.nc

#===============================================================================
# do not edit below this point
#===============================================================================

#-------------------------------------------------------------------------------
# create scrip input namelist files
#-------------------------------------------------------------------------------

cat >! scrip_test_in_a2o_aavg << EOF
&remap_inputs
   field_choice = 2
   interp_file = '$mapFn_a2o_aavg'
   output_file = '$outFn_a2o_aavg'
/
EOF

cat >! scrip_test_in_o2a_aavg << EOF
&remap_inputs
   field_choice = 2
   interp_file = '$mapFn_o2a_aavg'
   output_file = '$outFn_o2a_aavg'
/
EOF

cat >! scrip_test_in_a2o_bilin << EOF
&remap_inputs
   field_choice = 2
   interp_file = '$mapFn_a2o_bilin'
   output_file = '$outFn_a2o_bilin'
/
EOF

cat >! scrip_test_in_o2a_bilin << EOF
&remap_inputs
   field_choice = 2
   interp_file = '$mapFn_o2a_bilin'
   output_file = '$outFn_o2a_bilin'
/
EOF

#-------------------------------------------------------------------------------
# run scrip: create the netCDF mapping data files
#-------------------------------------------------------------------------------
# notes: 
# o scrip_test namelist file must be named "scrip_test_in"
#-------------------------------------------------------------------------------

cp scrip_test_in_a2o_aavg scrip_test_in
$SCRIPDIR/scrip_test

cp scrip_test_in_o2a_aavg scrip_test_in
$SCRIPDIR/scrip_test

cp scrip_test_in_a2o_bilin scrip_test_in
$SCRIPDIR/scrip_test

cp scrip_test_in_o2a_bilin scrip_test_in
$SCRIPDIR/scrip_test

#-------------------------------------------------------------------------------
# append documentation to the mapping data files (netCDF global attribute)
#-------------------------------------------------------------------------------

foreach FILE ( $outFn_o2a_aavg $outFn_a2o_aavg $outFn_o2a_bilin $outFn_a2o_bilin)
  ncatted -O -h -a Created_by,global,a,c,"`whoami`, `date`" $FILE
end


exit(0)
