#!/bin/csh -fv 


# ---------------------------------------------------------------
# mk_runoff_remap runs 'scrip', the mapping algorithm for CCSM.
# Scrip automatically looks for a fill called 'scrip_in' for input.
#
# This shell script overwrites the 'scrip_in' file created by
# mk_remap.csh.
# ---------------------------------------------------------------

set echo off
set verbose

set DATE    = "`date +%y%m%d`"

# -----------------------------------------------------------------
# User Defined -----------------------------------------------------
# -----------------------------------------------------------------

setenv TOOLSDIR /your/setup/tools/here

set griddir  = /your/grids/here
set mssout = /$LOGNAME/csm/$CASE/cpl   # only for NCAR MSS
set wkdir =  /your/working/dir/here

# -----------------------------------------------------------------
# If local to NCAR with access to scd machines:
# Scrip is available from the SVN repository: 
# svn-ccsm-models.cgd.ucar.edu/tools/mapping/scrip
# NCAR local copy /fis/cgd/oce/yeager/scrip1.4
# -----------------------------------------------------------------
set scripdir = /your/scrip1.4/dir/here

# -----------------------------------------------------------------
# Input files -----------------------------------------------------
# -----------------------------------------------------------------
# note: ocn grid created w/mk_remap.csh (pop.da and kmt files used)
#     : lnd grid taken from  setup tools cpl/grids (or see cpl/grids/README)
set ocngridfile = $griddir/gx3Paleo_yyddmm.nc
set lndgridfile = $griddir/remap_grid_ll2.0deg_CLM.nc

# -----------------------------------------------------------------
# Output files -----------------------------------------------------
# -----------------------------------------------------------------

set map1_file  = map_r1x1_to_gx3Paleo_$DATE.nc
set map1_name   = 'LL2.0deg_CLM to <add your ocean grid description> Mapping'
set map_method = conservative		# labelled with aave
set normalize_opt = destarea

cd $wkdir

#################################
# SET HERE FILE INPUT
#################################
cat >! scrip_in << EOF
&remap_inputs
    num_maps = 1
    grid1_file = '$lndgridfile'
    grid2_file = '$ocngridfile'
    interp_file1 = '$map1_file'
    map1_name = '$map1_name'
    map_method = '$map_method'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10 
/
EOF

#################################
# RUN SCRIP ROUTINES
#################################

${scripdir}/scrip 

#################################
# ADD DOCUMENTATION
#################################
foreach i ($map1_file)
  ncatted -O -h -a Created_by,global,a,c,"`whoami`, `date`" $i
  ncatted -O -h -a 1D_grid_indexing,global,a,c,"if n is 1D index, i runs fast, j runs slow: n=(j-1)*fast_grid_dim+i" $i
end

# mswrite -t3650 -w CCSM $map1_file $mssout/$map1_file
exit(0)
