#!/bin/csh -fv 

set echo off
set verbose

set DATE    = "`date +%y%m%d`"

set CASE  = wais

setenv TOOLSDIR /your/setuptools/here/setup_tools
setenv RUNDIR   /your/working/dir/here

# NCAR local copy /fis/cgd/oce/yeager/scrip1.4
set mssout = /$LOGNAME/csm/$CASE/cpl   # only for NCAR MSS
set griddir = /your/grid/dir/here
set scripdir = /your/scrip1.4/dir/here
set wkdir =  $RUNDIR
set nx      = 320  			# number of i gridpoints
set ny      = 384   	 		# number of j gridpoints 
# -----------------------------------------------------------------
# Input files -----------------------------------------------------
# -----------------------------------------------------------------
set popgrid = grid.pop.da	      	# binary grid file
set kmtgrid = kmt.da		      	# binary kmt file

set atmgridfile = $TOOLSDIR/cpl/grids/T85_011127.nc		
# -----------------------------------------------------------------
# Output labels -----------------------------------------------------
# -----------------------------------------------------------------
set map1_name   = 'gx1v3 to T85_011127 Mapping'
set map2_name   = 'T85_011127 to gx1v3 Mapping'
set ocngridname = 'Description of your case and grid here'
set ares_short = T85
set ares = T85_011127
set ores = gx1v3

# -----------------------------------------------------------------
# Output filenames ------------------------------------------------
# -----------------------------------------------------------------
set ocngridfile = $wkdir/${CASE}_${res}_${DATE}.nc
set map1_filea  = $wkdir/map_${ores}_to_${ares}_aave_da_$DATE.nc
set map2_filea  = $wkdir/map_${ares}_to_${ores}_aave_da_$DATE.nc
set map1_fileb  = $wkdir/map_${ores}_to_${ares}_bilin_da_$DATE.nc
set map2_fileb  = $wkdir/map_${ares}_to_${ores}_bilin_da_$DATE.nc
set map_methoda   = conservative	# labelled with aave
set map_methodb   = bilinear		# labelled with bilin
set normalize_opt = destarea
set map1a  = map_${ores}_to_${ares}_aave_da_$DATE.nc
set map2a  = map_${ares}_to_${ores}_aave_da_$DATE.nc
set map1b  = map_${ores}_to_${ares}_bilin_da_$DATE.nc
set map2b  = map_${ares}_to_${ores}_bilin_da_$DATE.nc

#################################
# SET HERE FILE INPUT
#################################
cd $wkdir

cat >! input.scrip_grid << EOF
$nx $ny
$ocngridname
${griddir}/${popgrid}
${griddir}/${kmtgrid}
$ocngridfile
1
EOF

cat >! scrip_ina << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_filea'
    interp_file2 = '$map2_filea'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methoda'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10 
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

cat >! scrip_inb << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_fileb'
    interp_file2 = '$map2_fileb'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methodb'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

#################################
# RUN SCRIP ROUTINES
#################################
#if !(-e $ocngridfile) then
 ${scripdir}/create_grids/myconvertPOPT < input.scrip_grid
#endif

mv scrip_ina scrip_in
${scripdir}/scrip
mv scrip_inb scrip_in
${scripdir}/scrip

#################################
# ADD DOCUMENTATION
#################################
foreach i ($ocngridfile $map1_filea $map2_filea $map1_fileb $map2_fileb)
  ncatted -O -h -a Created_by,global,a,c,"`whoami`, `date`" $i
  ncatted -O -h -a 1D_grid_indexing,global,a,c,"if n is 1D index, i runs fast, j runs slow: n=(j-1)*fast_grid_dim+i" $i
end

#################################
# CLEAN UP
#################################
# /usr/bin/rm -f input.scrip_grid


# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map1_filea mss:$mssout/$map1a
# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map2_filea mss:$mssout/$map2a
# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map1_fileb mss:$mssout/$map1b
# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map2_fileb mss:$mssout/$map2b

exit(0)
