#!/bin/csh -fv 

set echo off
set verbose

set DATE    = "20`date +%y%m%d`"

set MYSRC = /MySourceDir
set WORK  = /MyScratchDir/
set CASE  = 10ka

setenv TOOLSDIR $MYSRC/setup_tools
setenv DATADIR  $TOOLSDIR/ocn/data

# NCAR LOCAL scripdir  
# set scripdir = /fis/cgd/oce/yeager/scrip1.4
set scripdir = /$MYSRC/scrip1.4
set rundir = /${WORK}/${CASE}/
set griddir = /$WORK}/${CASE}/ocn
set wkdir = /ptmp/nanr/${CASE}/cpl 

# NCAR archive
# set mssout = /CCSM/paleo/b30.180/${CASE}/cpl_mapping

if (! -e ${rundir}) then
  echo \$rundir ${rundir} does not exist: Creating
  mkdir $rundir
endif
if (! -e ${griddir}) then
  echo \$griddir ${griddir} does not exist: Creating
  mkdir $griddir
endif
if (! -e ${wkdir}) then
  echo \$wkdir ${wkdir} does not exist: Creating
  mkdir $wkdir
endif

set nx      = 320  			# number of i gridpoints (longitudes)
set ny      = 384   	 		# number of j gridpoints (latitudes)
# -----------------------------------------------------------------
# Input files -----------------------------------------------------
# -----------------------------------------------------------------
set popgrid = horiz_grid_20010402.ieeer8       		# binary grid file
set kmtgrid = topography_kmt.ieeei4            		# binary kmt file with Hudson's bay removed.

set atmdomain   = T42_001005.nc
set atmgridfile = /fs/cgd/csm/mapping/grids/$atmdomain

# -----------------------------------------------------------------
# Output labels -----------------------------------------------------
# -----------------------------------------------------------------

set ocnres = '10k_gx1v3'
set atmres = 'T42_001005'

set map1_name   = ocnres' to 'atmres' Mapping('${kmtgrid}' to '${atmdomain}')'
set map2_name   = atmres' to 'ocnres' Mapping('${atmdomain}' to '${kmtgrid}')'
set ocngridname = '10ka'

# -----------------------------------------------------------------
# Output filenames ------------------------------------------------
# -----------------------------------------------------------------
set ocngridfile = $wkdir/ocn_${CASE}_$DATE.nc
set map1_filea  = $wkdir/map_${ocnres}_to_${atmres}_aave_da_$DATE.nc
set map2_filea  = $wkdir/map_${atmres}_to_${ocnres}_aave_da_$DATE.nc
set map1_fileb  = $wkdir/map_${ocnres}_to_${atmres}_bilin_da_$DATE.nc
set map2_fileb  = $wkdir/map_${atmres}_to_${ocnres}_bilin_da_$DATE.nc
set map_methoda   = conservative	# labelled with aave
set map_methodb   = bilinear		# labelled with bilin
set normalize_opt = destarea
set map1a  = map_${ocnres}_to_${atmres}_aave_da_$DATE.nc
set map2a  = map_${atmres}_to_${ocnres}_aave_da_$DATE.nc
set map1b  = map_${ocnres}_to_${atmres}_bilin_da_$DATE.nc
set map2b  = map_${atmres}_to_${ocnres}_bilin_da_$DATE.nc

#################################
# SET HERE FILE INPUT
#################################
cd $wkdir

cat >! input.scrip_grid << EOF
$nx $ny
$ocngridname
${griddir}/${popgrid}
${griddir}/${kmtgrid}
$ocngridfile
1
EOF

cat >! scrip_ina << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_filea'
    interp_file2 = '$map2_filea'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methoda'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10 
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

cat >! scrip_inb << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_fileb'
    interp_file2 = '$map2_fileb'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methodb'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

#################################
# RUN SCRIP ROUTINES
#################################
#if !(-e $ocngridfile) then
 ${scripdir}/create_grids/myconvertPOPT < input.scrip_grid
 # ${scripdir}/grids/convertPOPT < input.scrip_grid
#endif

mv scrip_ina scrip_in
${scripdir}/scrip
mv scrip_inb scrip_in
${scripdir}/scrip

#################################
# ADD DOCUMENTATION
#################################
foreach i ($ocngridfile $map1_filea $map2_filea $map1_fileb $map2_fileb)
  ncatted -O -h -a Created_by,global,a,c,"`whoami`, `date`" $i
  ncatted -O -h -a 1D_grid_indexing,global,a,c,"if n is 1D index, i runs fast, j runs slow: n=(j-1)*fast_grid_dim+i" $i
end

#################################
# CLEAN UP
#################################
# /usr/bin/rm -f input.scrip_grid

# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map1_filea mss:$mssout/$map1a
# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map2_filea mss:$mssout/$map2a
# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map1_fileb mss:$mssout/$map1b
# msrcp -pe 3650 -wpwd nanr -pr 93300024 $map2_fileb mss:$mssout/$map2b

exit(0)

