#!/bin/csh -fv 


set echo off
set verbose

set DATE    = "`date +%y%m%d`"

set CASE  = 445maR

setenv TOOLSDIR /your/setuptools/here/setup_tools
setenv RUNDIR   /your/working/dir/here

# NCAR local copy /fis/cgd/oce/yeager/scrip1.4
set mssout = /$LOGNAME/csm/$CASE/cpl   # only for NCAR MSS
set griddir = /your/grid/data/here
set scripdir = /your/scrip1.4/dir/here/scrip1.4
set wkdir = $RUNDIR
set nx      = 100  			# number of i gridpoints (longitudes)
set ny      = 116   	 		# number of j gridpoints (latitudes)
# -----------------------------------------------------------------
# Input files -----------------------------------------------------
# -----------------------------------------------------------------
set popgrid = grid.pop.da  	# binary grid file
set kmtgrid =  kmt.final.da    	# binary kmt file

set atmgridfile = $TOOLSDIR/cpl/grids/T31_040122.nc
# -----------------------------------------------------------------
# Output labels -----------------------------------------------------
# -----------------------------------------------------------------
set map1_name   = 'gx3Paleo to T31_040122 Mapping'
set map2_name   = 'T31_040122 to gx3Paleo Mapping'
set ocngridname = 'Description of your case and grid here'

# -----------------------------------------------------------------
# Output filenames ------------------------------------------------
# -----------------------------------------------------------------
set ocngridfile = $wkdir/${CASE}_gx3Paleo_$DATE.nc
set map1_filea  = $wkdir/map_gx3Paleo_to_T31_aave_da.nc
set map2_filea  = $wkdir/map_T31_to_gx3Paleo_aave_da.nc
set map1_fileb  = $wkdir/map_gx3Paleo_to_T31_bilin_da.nc
set map2_fileb  = $wkdir/map_T31_to_gx3Paleo_bilin_da.nc
set map_methoda   = conservative	# labelled with aave
set map_methodb   = bilinear		# labelled with bilin
set normalize_opt = destarea
set map1a  = map_gx3Paleo_to_T31_aave_da_$DATE.nc
set map2a  = map_T31_to_gx3Paleo_aave_da_$DATE.nc
set map1b  = map_gx3Paleo_to_T31_bilin_da_$DATE.nc
set map2b  = map_T31_to_gx3Paleo_bilin_da_$DATE.nc

#################################
# SET HERE FILE INPUT
#################################
cd $wkdir

cat >! input.scrip_grid << EOF
$nx $ny
$ocngridname
${griddir}/${popgrid}
${griddir}/${kmtgrid}
$ocngridfile
1
EOF

cat >! scrip_ina << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_filea'
    interp_file2 = '$map2_filea'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methoda'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10 
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

cat >! scrip_inb << EOF
&remap_inputs
    num_maps = 2
    grid1_file = '$ocngridfile'
    grid2_file = '$atmgridfile'
    interp_file1 = '$map1_fileb'
    interp_file2 = '$map2_fileb'
    map1_name = '$map1_name'
    map2_name = '$map2_name'
    map_method = '$map_methodb'
    normalize_opt = '$normalize_opt'
    output_opt = 'ncar-csm'
    restrict_type = 'latlon'
    num_srch_bins = 10
    luse_grid1_area = .false.
    luse_grid2_area = .false.
/
EOF

#################################
# RUN SCRIP ROUTINES
#################################
#if !(-e $ocngridfile) then
 ${scripdir}/create_grids/myconvertPOPT < input.scrip_grid
#endif

mv scrip_ina scrip_in
${scripdir}/scrip
mv scrip_inb scrip_in
${scripdir}/scrip

#################################
# ADD DOCUMENTATION
#################################
foreach i ($ocngridfile $map1_filea $map2_filea $map1_fileb $map2_fileb)
  ncatted -O -h -a Created_by,global,a,c,"`whoami`, `date`" $i
  ncatted -O -h -a 1D_grid_indexing,global,a,c,"if n is 1D index, i runs fast, j runs slow: n=(j-1)*fast_grid_dim+i" $i
end

#################################
# CLEAN UP
#################################
# /usr/bin/rm -f input.scrip_grid

# msrcp -pe 3650 -wpwd shields -pr 93300024 $map1_filea mss:$mssout/$map1a
# msrcp -pe 3650 -wpwd shields -pr 93300024 $map2_filea mss:$mssout/$map2a
# msrcp -pe 3650 -wpwd shields -pr 93300024 $map1_fileb mss:$mssout/$map1b
# msrcp -pe 3650 -wpwd shields -pr 93300024 $map2_fileb mss:$mssout/$map2b

exit(0)
