;====================================================================
; reads a CCSM/SCRIP ocn grid file nc and writes grid_area to 
; unformatted binary file as real*8
; for use in idl runoff check tool test_r1x1toOCN_remapping.run
; cshields,feb07
;
; run on ibm for big endian, linux for little endian
;

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

;==========================================================

begin

scrip_grid = "/your/filepath/oceandomainfile/gx3Paleo_<date>.nc"
area_bin = "/your/filepath/gen_runoffmap/tools/tarea_gx3oR.lendian"

;==================> open file 

gf = addfile(scrip_grid,"r")

;============= read in vars

grid_area = gf->grid_area
print("data read...")

;====== write to unformatted bin 

fbinrecwrite(area_bin,-1,grid_area)
print("data written...")


end 
