;=========================================================; 
; reads in data merged topo kmt file
; read in template cam initial (Netcdf) file 
; makes modifications, writes out new file
; 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

;====================user defined parameters

filename_topo    = getenv("INPUT_DATA_NC")
filename_template= getenv("INPUT_DATA_SKELETON")    
new_cdf          = getenv("OUTPUT_DATA_NC")
modtext          = getenv("MODTEXT")
regrid           = getenv("REGRID")     ; regrid topo data 0 no 1 yes
	         ; NOTE see ncl function/procedures to pick best interp.
		 ; scheme for your data, currently set up to interp.
		 ; from (ex.,2x2) to (T31) (bilinear interp, similar to definesurf)
hires            = getenv("HIRES")
                 ; true/false: add from_hires attribute to phis, 
	         ; this will force model to do additional spectral
	         ; spectral filtering at runtime	 
standalone       = getenv("STANDALONE") 
		 ; variables for cam standalone

;new inputs for calculated T profile
Tpole            = getenv("TPOLE") 
Teq              = getenv("TEQ") 

;============== read topo ascii file

topof = addfile(filename_topo,"r")
topf = topof->topo

ilat = topof->lat
ilon = topof->lon
nilat = dimsizes(ilat)
nilon = dimsizes(ilon)
topf@_FillValue = 0.
topf = mask(topf,topf.lt.0,False)
delete(topf@_FillValue)
print("Atm data read")

;=============== read in atm template netcdf file
 
atm = addfile(filename_template,"r")
lat  = atm->lat
lon  = atm->lon
P0   = atm->P0
lev  = atm->lev
ilev = atm->ilev
time = atm->time
date_written = atm->date_written
time_written = atm->time_written
ntrm = atm->ntrm
ntrn = atm->ntrn
ntrk = atm->ntrk
ndbase = atm->ndbase
nsbase = atm->nsbase
nbdate = atm->nbdate
nbsec  = atm->nbsec
mdt    = atm->mdt
hyai   = atm->hyai
hybi   = atm->hybi
hyam   = atm->hyam
hybm   = atm->hybm
gw     = atm->gw
ndcur  = atm->ndcur
nscur  = atm->nscur
date   = atm->date
datesec= atm->datesec
nsteph = atm->nsteph
U      = atm->U
V      = atm->V
T      = atm->T
Q      = atm->Q
PS     = atm->PS
PHIS   = atm->PHIS
SGH    = atm->SGH
LANDM  = atm->LANDM
CWAT   = atm->CWAT
 
nlon  = dimsizes(lon)
nlat  = dimsizes(lat)
nlev  = dimsizes(lev)
nilev = dimsizes(ilev)
ntimes= dimsizes(time)
dimsc = dimsizes(date_written)
chars = dimsc(1)

print("nlon = " + nlon)
print("nlat = " + nlat)
print("nlev = " + nlev)
print("nilev= " + nilev)
print("ntimes = " + ntimes)
print("chars = "+ chars)

;======= create oro 

orof = new((/nilat,nilon/),float)
orof@_FillValue = 0
orof = 1.
orof = mask(orof,topf.eq.0,False)
print("Oro created from topography")
delete(orof@_FillValue)

; USING linint2: interpolate from one grid to another grid
; using bilinear interpolation. Missing values are allowed.
; produces similar interpolation used by jim's "definesurf"

orof@_FillValue = -9999.
topf@_FillValue = 1e30

if(regrid.eq.1)then
  top = linint2_Wrap (ilon,ilat,topf, True, lon,lat, 0)
  oro = linint2_Wrap (ilon,ilat,orof, True, lon,lat, 0)
  print("Atm topography/oro interpolated")
else
  top = topf
  oro = orof
end if 
; top!0 = "lat"
; top!1 = "lon"
; top&lat = lat
; top&lon = lon
; top@long_name = "Topography"
; printVarSummary(top)

;======= create landm field and landm_coslat field

landm = new((/ntimes,nlat,nlon/),double)
do nlt = 0, nlat-1
do nln = 0, nlon-1
 if(top(nlt,nln).gt.0)then   ; adjust as appropriate 
  landm(0,nlt,nln) = 1   ;land
 else
  landm(0,nlt,nln) = 0   ;ocean
 end if
end do
end do
landm_sm = smth9(landm,.5,.25,True)
printVarSummary(landm)

landm_coslat = new((/ntimes,nlat,nlon/),double)
degrad = 0.0174533  ; conversion of degrees to radians
latr = lat*degrad 
latrC = conform(landm_sm,latr,1)
landm_coslat = landm_sm
do nlt = 0, nlat-1
do nln = 0, nlon-1
 if(landm_sm(0,nlt,nln).lt.0.999)then 
  landm_coslat(0,nlt,nln) = landm_sm(0,nlt,nln)*cos(latrC(0,nlt,nln)) 
 end if
end do
end do
print("LANDM/LANDM_COSLAT fields created from interpolated ORO/TOPO")

;====== compute new values for t,ps,phis,sgh,u,v,q,cwat

phis = new((/ntimes,nlat,nlon/),double)
sgh  = new((/ntimes,nlat,nlon/),double)
phis(0,:,:) = top *9.80616
sgh(0,:,:)  = top*.13
t = T
ps = PS
u = U
v = V
q = Q
cwat = CWAT

;t and ps calulation
; calculate zonal t
; make eq-pole temp gradient = half cosine wave

      cst = new(nlat,double)
      degrad = 0.0174533  ; conversion of degrees to radians
;     temppole = 12.
;     tempeq   = 28.
      temppole = stringtofloat(Tpole)
      tempeq   = stringtofloat(Teq)
      latr = lat*degrad 
      cst= cos(latr)
      cstC = conform(t,cst,1)
      t= temppole + (tempeq-temppole)*cstC
;     t = t + 273.   ;convert to deg K, Christine old ccsm2 script
;     t = t + 273.16  ;convert to deg K, compatible with ccsm3 conversion
      t = t + 273.15  ;new (3/28/07) convert to deg K, compatible with ccsm3 conversion
      print("zonal t calculated")

; calculate sfc prs from above temp and topo (units Pa)
      z1 = 0.
      slp = 101200.
      z2 = phis/9.8  ; array(0,lat,lon)
      H  = 29.3*( t(:,:,0,:) )  ; convert t to deg K
      ps = slp* ( exp(-(z2-z1)/H) )
      print("ps calculated")

; calcualte thermal wind
      dy = new(nlat,double)
      Rf = -287./1e-4 ; gas constant (J perdeg persec) / coriolis (persec)
      deg2m = 111000. ;m per deg lat
      pref = 992. ;mb (levels are in mb also...units cancel)
      do nlt = 1,nlat-2
       dy(nlt) = (lat(nlt+1)-lat(nlt-1))*deg2m
      end do
      dy(1) = dy(2)
      dy(nlat-1) = dy(nlat-1)
      nlatd2 = nlat/2

      do nlv = 0,nlev-1
      do nln = 0,nlon-1
      do nlt=1,nlatd2 
       u(:,nlt,nlv,nln)=  \
       -1*Rf*((t(:,nlt+1,nlv,nln)-t(:,nlt-1,nlv,nln))/dy(nlt))*(log(pref/lev(nlv)))
      end do
      do nlt=nlatd2+1,nlat-2 
       u(:,nlt,nlv,nln)=   \
         Rf*((t(:,nlt+1,nlv,nln)-t(:,nlt-1,nlv,nln))/dy(nlt))*(log(pref/lev(nlv)))
      end do
      end do
      end do
      u(:,0,:,:) = u(:,1,:,:)
      u(:,nlat-1,:,:) = u(:,nlat-2,:,:)
      print("u calculated")

; assign v and q and cwat
      v = 0.
      q(:,:,0:10,:)  = 1.e-06     ;top to 139 sigma/prs level
      q(:,:,11:16,:) = 1.e-05     ;139 to 368  
      q(:,:,17:19,:) = 1.e-04     ;433 to 600
      q(:,:,20:nlev-1,:)= 1.e-03  ;696 to 992
      cwat = 0.
      print("v and q values assigned")

;==== if standalone create following vars

if(standalone.eq.1)then
  
 tsice = new((/ntimes,nlat,nlon/),double)
 ts1 = new((/ntimes,nlat,nlon/),double)
 ts2 = new((/ntimes,nlat,nlon/),double)
 ts3 = new((/ntimes,nlat,nlon/),double)
 ts4 = new((/ntimes,nlat,nlon/),double)
 snowhice = new((/ntimes,nlat,nlon/),double)
 landfrac = new((/ntimes,nlat,nlon/),double)
  tsice = 271.35
  ts1  = t(:,:,nlev-1,:)
  ts2  = t(:,:,nlev-1,:)
  ts3  = t(:,:,nlev-1,:)
  ts4  = t(:,:,nlev-1,:)
  snowhice = 0.
  landfrac = landm
end if

;========create new file surface file, preserve old file
;        attributes, write out variables with no changes

;----> write new .nc file

system("rm "+new_cdf)
cdf = addfile(new_cdf, "c")
print("Creating new init file....")

; define dimensions
dimNames = (/"lat","lon","lev","ilev","time","chars"/)
dimSizes = (/ nlat, nlon, nlev, nilev,  -1, chars/)
dimUnlim = (/ False,  False,  False,   False,   True, False/)
filedimdef(cdf,dimNames,dimSizes,dimUnlim)

;define variable names
filevardef(cdf,"lat","double",(/"lat"/))
filevardef(cdf,"lon","double",(/"lon"/))
filevardef(cdf,"lev","double",(/"lev"/))
filevardef(cdf,"ilev","double",(/"ilev"/))
filevardef(cdf,"time","double",(/"time"/))
filevardef(cdf,"hyai","double",(/"ilev"/))
filevardef(cdf,"hybi","double",(/"ilev"/))
filevardef(cdf,"hyam","double",(/"lev"/))
filevardef(cdf,"hybm","double",(/"lev"/))
filevardef(cdf,"gw","double",(/"lat"/))
filevardef(cdf,"date_written","character",(/"time","chars"/))
filevardef(cdf,"time_written","character",(/"time","chars"/))
filevardef(cdf,"date","integer",(/"time"/))
filevardef(cdf,"datesec","integer",(/"time"/))
filevardef(cdf,"nsteph","integer",(/"time"/))
filevardef(cdf,"U","double",(/"time","lat","lev","lon"/))
filevardef(cdf,"V","double",(/"time","lat","lev","lon"/))
filevardef(cdf,"T","double",(/"time","lat","lev","lon"/))
filevardef(cdf,"Q","double",(/"time","lat","lev","lon"/))
filevardef(cdf,"PS","double",(/"time","lat","lon"/))
filevardef(cdf,"PHIS","double",(/"time","lat","lon"/))
filevardef(cdf,"SGH","double",(/"time","lat","lon"/))
filevardef(cdf,"LANDM","double",(/"time","lat","lon"/))
filevardef(cdf,"CWAT","double",(/"time","lat","lev","lon"/))
filevardef(cdf,"LANDM_COSLAT","double",(/"time","lat","lon"/))

; write variables
cdf->lat    = lat
cdf->lon    = lon
cdf->lev    = lev
cdf->ilev   = ilev
cdf->time   = time
cdf->hyai   = hyai
cdf->hybi   = hybi
cdf->hyam   = hyam
cdf->hybm   = hybm
cdf->gw     = gw

cdf->P0 = P0
cdf->date_written = date_written
cdf->time_written = time_written

cdf->ntrm = ntrm
cdf->ntrn = ntrn
cdf->ntrk = ntrk
cdf->ndbase = ndbase
cdf->nsbase = nsbase
cdf->nbdate = nbdate
cdf->nbsec  = nbsec
cdf->mdt    = mdt
cdf->ndcur  = ndcur
cdf->nscur  = nscur
cdf->date   = date
cdf->datesec= datesec
cdf->nsteph = nsteph
cdf->U = U
cdf->V = V
cdf->T = T
cdf->Q = Q
cdf->Q = Q
cdf->PS   = PS 
cdf->PHIS = PHIS
cdf->SGH  = SGH
cdf->LANDM= LANDM
cdf->CWAT =  CWAT

; preserve file attributes
cdf@Conventions = atm@Conventions
cdf@logname = atm@logname
cdf@host = atm@host
cdf@source = atm@source
cdf@case = atm@case
cdf@title = atm@title

; add new text
cdf@Modifications = modtext
cdf@history = "template b20.604gm.cam2.i.0400-01-01-00000.nc" 

print("New file skeleton has been written...")

  
;========== delete oldvar from new file and write out new
;           variable
print("deleting old values, new ones writing...")


delete(cdf->PHIS)
delete(cdf->SGH)
delete(cdf->LANDM)
delete(cdf->PS)
delete(cdf->T)
delete(cdf->U)
delete(cdf->V)
delete(cdf->Q)
delete(cdf->CWAT)

; add hires tag on phis if requested (will do additional spectral
; filtering at model runtime)
if(hires.eq."true")then
 phis@from_hires = "true" 
end if

cdf->PHIS =  phis
cdf->SGH =  sgh
cdf->LANDM = landm_sm 
cdf->PS =  ps
cdf->T = t 
cdf->U =  u 
cdf->V =  v 
cdf->Q =  q 
cdf->CWAT =  cwat 
cdf->LANDM_COSLAT = landm_coslat
if(standalone.eq.1)then
 cdf->LANDFRAC = landfrac
 cdf->TSICE = tsice
 cdf->TS1   = ts1
 cdf->TS2   = ts2
 cdf->TS3   = ts3
 cdf->TS4   = ts4
 cdf->SNOWHICE = snowhice
end if

print(new_cdf + " has been written")



end
    


