#!/bin/csh -f
set echo
set verbose
#----------------------- cami_create.ncl -----------------------------
#
# all work is done in directory where script and code resides 
#
# this cshell script runs the ncl code ccsm_cami_create_script.ncl  
#
# read in template (skeleton file) for cam initial file, a topo/bathemetry
# netcdf, makes modificatioins, writes out new file
#
#-----------------------------------------------------------------
# YOU NEED  : ccsm_cami_create_ccsm3.ncl,cami_create_ccsm3.csh
# TO RUN    : cami_create_ccsm3.csh 
# NOTE      : make sure "limits" on your machine are set appropriately
#           : if not set large enough, the program may not have enough
#             space/memory to run
#-----------------------------------------------------------------
#
#----------------------------------------------------------------------------
# USER:  specify input/output pathnames as well as other user defined parameters
# with enviromental variables set in this script 
# NOTE:  Be sure to specify the path to your input topography (INFILE) 
#----------------------------------------------------------------------------

setenv INFILE  100ma_topo_070404.nc
setenv OUTFILE 100ma_cami_t31.nc
setenv CASE    100ma
setenv TOOLSDIR /your/setup_tools/base/dir/here		# set to your local copy of tools
setenv WKDIR /ptmp/$LOGNAME/$CASE
setenv DATADIR $WKDIR/data

#--------------------------------------

setenv DATAIN  $TOOLSDIR/atm/data
setenv INPUT_DATA_SKELETON $DATAIN/ccmi_${RESOLUTION}_skeleton.nc
setenv INPUT_DATA_NC $DATADIR/$INFILE
setenv OUTPUT_DATA_NC    $DATADIR/$OUTFILE

setenv MODTEXT TEST_Cret 
setenv REGRID 1			# interpolate to model grid (t31)
setenv HIRES true
setenv STANDALONE 0 		# for cam standalone 
setenv NCL $NCARG_ROOT/bin/ncl

#Must set for half-cosine Equator to Pole Temperature I.C.:
setenv TEQ     28.
setenv TPOLE   12.

#----------------------------------------------------------------------------
#  run 
# change NCL to where ever the latest version resides. 
#----------------------------------------------------------------------------
$NCL  $TOOLSDIR/atm/src/ccsm_cami_create_ccsm3.ncl	# TOOLS copy

exit

