;=========================================================; 
; correct LANDM_COSLAT field in CAM init file
;
; opens cam init file (netcdf)
; computes correct landmcoslat and
; writes it to cam init file
; NOTE: this routine modifies the netcdf file it is given

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl";


begin

;====================user defined parameters

filename         = getenv("CAM2_I")

;=============== read in atm netcdf file
 
atm = addfile(filename,"w")
lat  = atm->lat
lon  = atm->lon
time = atm->time
LANDM  = atm->LANDM
 
nlon  = dimsizes(lon)
nlat  = dimsizes(lat)
ntimes= dimsizes(time)

print("nlon = " + nlon)
print("nlat = " + nlat)

;======= create landm_coslat field

landm_sm = smth9(LANDM,.5,.25,True)

landm_coslat = new((/ntimes,nlat,nlon/),double)
degrad = 0.0174533  ; conversion of degrees to radians
latr = lat*degrad 
latrC = conform(landm_sm,latr,1)
landm_coslat = landm_sm
do nlt = 0, nlat-1
do nln = 0, nlon-1
 if(landm_sm(0,nlt,nln).lt.0.999)then 
  landm_coslat(0,nlt,nln) = landm_sm(0,nlt,nln)*cos(latrC(0,nlt,nln)) 
 end if
end do
end do


;======== write changes to .nc file
atm@Modifications = "b30.105.cam2.i.0100-01-01.LGM_c050523.nc with LANDM_COSLAT field corrected"
hist=atm@history
;atm@history = hist + "; fix_landmcoslat.ncl on b30.105.cam2.i.0100-01-01.LGM_c050523.nc"

;delete(atm->LANDM_COSLAT)

atm->LANDM_COSLAT = landm_coslat

print("fixed LANDM_COSLAT has been written")

end
    


